/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.oauth;

import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.vorto.repository.oauth.EclipseOAuthProviderConfiguration;
import org.eclipse.vorto.repository.oauth.IOAuthFlowConfiguration;
import org.eclipse.vorto.repository.oauth.IOAuthProvider;
import org.eclipse.vorto.repository.oauth.OAuthUser;
import org.eclipse.vorto.repository.oauth.internal.JwtToken;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.provider.OAuth2Authentication;

public class EclipseRepositoryAuthProvider
implements IOAuthProvider {
    @Autowired
    private EclipseOAuthProviderConfiguration configuration;
    private String clientId;
    private static final String ID = "ECLIPSE";

    @Autowired
    public EclipseRepositoryAuthProvider(@Value(value="${eclipse.oauth2.client.clientId}") String clientId, EclipseOAuthProviderConfiguration eclipseTokenService) {
        this.clientId = Objects.requireNonNull(clientId);
        this.configuration = Objects.requireNonNull(eclipseTokenService);
    }

    public String getId() {
        return ID;
    }

    public boolean canHandle(Authentication auth) {
        if (auth == null || !(auth instanceof OAuth2Authentication)) {
            return false;
        }
        OAuth2Authentication oauth2Auth = (OAuth2Authentication)auth;
        if (oauth2Auth.getOAuth2Request() == null) {
            return false;
        }
        return this.clientId.equals(oauth2Auth.getOAuth2Request().getClientId());
    }

    public boolean canHandle(String jwtToken) {
        Optional maybeJwtToken = JwtToken.instance((String)jwtToken);
        return jwtToken != null && jwtToken.trim().length() > 0 && !maybeJwtToken.isPresent();
    }

    public Authentication authenticate(HttpServletRequest request, String jwtToken) {
        return this.configuration.getUserInfoTokenService().loadAuthentication(jwtToken);
    }

    public OAuthUser createUser(Authentication authentication) {
        Authentication userAuthentication;
        OAuthUser user = new OAuthUser();
        user.setUserId(authentication.getName());
        user.setDisplayName(authentication.getName());
        if (authentication instanceof OAuth2Authentication && (userAuthentication = ((OAuth2Authentication)authentication).getUserAuthentication()).getDetails() != null && ((Map)userAuthentication.getDetails()).containsKey("email")) {
            user.setEmail((String)((Map)userAuthentication.getDetails()).get("email"));
        }
        HashSet roles = new HashSet();
        authentication.getAuthorities().forEach(e -> roles.add(e.getAuthority()));
        user.setRoles(roles);
        return user;
    }

    public boolean supportsWebflow() {
        return true;
    }

    public Optional<IOAuthFlowConfiguration> getWebflowConfiguration() {
        return Optional.of(this.configuration);
    }

    public String getLabel() {
        return "Eclipse";
    }
}

