/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.oauth;

import javax.servlet.http.HttpServletRequest;
import org.eclipse.vorto.repository.oauth.AbstractOAuthProviderConfiguration;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.security.oauth2.resource.UserInfoTokenServices;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeResourceDetails;

public class EclipseOAuthProviderConfiguration
extends AbstractOAuthProviderConfiguration {
    private static final String LOGOUT_URL = "/logout";
    private final String contextPath;

    public EclipseOAuthProviderConfiguration(@Value(value="${eclipse.oauth2.resource.userInfoUri}") String eclipseUserInfoEndpointUrl, @Value(value="${eclipse.oauth2.client.clientId}") String eclipseClientId, @Value(value="${server.contextPath}") String contextPath) {
        super(new UserInfoTokenServices(eclipseUserInfoEndpointUrl, eclipseClientId));
        if (contextPath.endsWith("/")) {
            contextPath = contextPath.substring(0, contextPath.length() - 1);
        }
        this.contextPath = contextPath;
    }

    public String getFilterProcessingUrl() {
        return "eclipse/login";
    }

    protected String getUserAttributeId() {
        return "login";
    }

    @Bean
    @ConfigurationProperties(value="eclipse.oauth2.client")
    public AuthorizationCodeResourceDetails eclipse() {
        return new AuthorizationCodeResourceDetails();
    }

    protected AuthorizationCodeResourceDetails createDetails() {
        return this.eclipse();
    }

    public String getLogoutUrl(HttpServletRequest request) {
        return this.getBaseUrl(request) + this.contextPath + LOGOUT_URL;
    }

    private String getBaseUrl(HttpServletRequest request) {
        if (request.getRequestURI().equals("/") || request.getRequestURI().equals("")) {
            return request.getRequestURL().toString();
        }
        return request.getRequestURL().toString().replace(request.getRequestURI(), "");
    }

    public String getLogoHref() {
        return "webjars/repository-web/dist/images/eclipse.png";
    }
}

