/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.oauth;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.vorto.repository.oauth.internal.Resource;

public class ResourceIdentificationHelper {
    private static final Pattern modelIdPattern = Pattern.compile("[a-zA-Z0-9_\\.]+:[a-zA-Z0-9_]+:[a-zA-Z0-9\\.\\-]+");
    private static final Pattern namespacePattern = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*(\\.[a-zA-Z_][a-zA-Z0-9_]*)+");

    public static Optional<Resource> identifyResource(String resourceUrl) {
        Matcher matcher = modelIdPattern.matcher(resourceUrl);
        if (matcher.find()) {
            return Optional.ofNullable(Resource.modelId((String)matcher.group()));
        }
        matcher = namespacePattern.matcher(resourceUrl);
        if (matcher.find()) {
            return Optional.ofNullable(Resource.namespace((String)matcher.group()));
        }
        return Optional.empty();
    }
}

