/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.oauth;

import javax.servlet.http.HttpServletRequest;
import org.eclipse.vorto.repository.oauth.AbstractOAuthProviderConfiguration;
import org.eclipse.vorto.repository.oauth.BoschIoTSuiteOAuthPrincipalExtractor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.security.oauth2.resource.PrincipalExtractor;
import org.springframework.boot.autoconfigure.security.oauth2.resource.UserInfoTokenServices;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeResourceDetails;

@Configuration
public class BoschIoTSuiteOAuthProviderConfiguration
extends AbstractOAuthProviderConfiguration {
    private static final String LOGOUT_URL = "/logout";
    private final String contextPath;

    public BoschIoTSuiteOAuthProviderConfiguration(@Value(value="${suite.oauth2.resource.userInfoUri}") String userInfoEndpointUrl, @Value(value="${suite.oauth2.client.clientId}") String clientId, @Value(value="${server.contextPath}") String contextPath) {
        super(new UserInfoTokenServices(userInfoEndpointUrl, clientId));
        this.tokenService.setPrincipalExtractor((PrincipalExtractor)new BoschIoTSuiteOAuthPrincipalExtractor());
        if (contextPath.endsWith("/")) {
            contextPath = contextPath.substring(0, contextPath.length() - 1);
        }
        this.contextPath = contextPath;
    }

    public String getFilterProcessingUrl() {
        return "suite/login";
    }

    protected String getUserAttributeId() {
        return "orig_id/sub";
    }

    @Bean
    @ConfigurationProperties(value="suite.oauth2.client")
    public AuthorizationCodeResourceDetails suite() {
        return new AuthorizationCodeResourceDetails();
    }

    protected AuthorizationCodeResourceDetails createDetails() {
        return this.suite();
    }

    public String getLogoutUrl(HttpServletRequest request) {
        return this.getBaseUrl(request) + this.contextPath + LOGOUT_URL;
    }

    private String getBaseUrl(HttpServletRequest request) {
        if (request.getRequestURI().equals("/") || request.getRequestURI().equals("")) {
            return request.getRequestURL().toString();
        }
        return request.getRequestURL().toString().replace(request.getRequestURI(), "");
    }

    public String getLogoHref() {
        return "webjars/repository-web/dist/images/bosch-social.png";
    }
}

