/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.oauth;

import java.security.PublicKey;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.vorto.repository.account.impl.DefaultUserAccountService;
import org.eclipse.vorto.repository.domain.IRole;
import org.eclipse.vorto.repository.oauth.AbstractOAuthProvider;
import org.eclipse.vorto.repository.oauth.BoschIoTSuiteOAuthProviderConfiguration;
import org.eclipse.vorto.repository.oauth.CiamIdNotFoundException;
import org.eclipse.vorto.repository.oauth.IOAuthFlowConfiguration;
import org.eclipse.vorto.repository.oauth.OAuthUser;
import org.eclipse.vorto.repository.oauth.internal.JwtToken;
import org.eclipse.vorto.repository.oauth.internal.PublicKeyHelper;
import org.eclipse.vorto.repository.oauth.internal.SpringUserUtils;
import org.eclipse.vorto.repository.services.UserNamespaceRoleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class BoschIoTSuiteOAuthProviderAuthCode
extends AbstractOAuthProvider {
    public static final String FAMILY_NAME = "family_name";
    public static final String GIVEN_NAME = "given_name";
    public static final String EMAIL = "email";
    private static final String RS256_ALG = "RS256";
    private final BoschIoTSuiteOAuthProviderConfiguration configuration;
    private final String clientId;
    private final DefaultUserAccountService userAccountService;
    private final UserNamespaceRoleService userNamespaceRoleService;
    private static final String ID = "BOSCH-IOT-SUITE-AUTH";

    @Autowired
    public BoschIoTSuiteOAuthProviderAuthCode(@Value(value="${suite.oauth2.client.clientId}") String clientId, @Value(value="${oauth2.verification.hydra.publicKeyUri: #{null}}") String hydraPublicKeyUri, @Autowired BoschIoTSuiteOAuthProviderConfiguration suiteOAuthProviderConfiguration, @Autowired DefaultUserAccountService userAccountService, @Autowired UserNamespaceRoleService userNamespaceRoleService) {
        super(PublicKeyHelper.supplier((RestTemplate)new RestTemplate(), (String)hydraPublicKeyUri), userAccountService, userNamespaceRoleService);
        this.clientId = Objects.requireNonNull(clientId);
        this.configuration = Objects.requireNonNull(suiteOAuthProviderConfiguration);
        this.userAccountService = Objects.requireNonNull(userAccountService);
        this.userNamespaceRoleService = Objects.requireNonNull(userNamespaceRoleService);
    }

    public BoschIoTSuiteOAuthProviderAuthCode(String clientId, Supplier<Map<String, PublicKey>> publicKeySupplier, BoschIoTSuiteOAuthProviderConfiguration suiteOAuthProviderConfiguration, DefaultUserAccountService userAccountService, UserNamespaceRoleService userNamespaceRoleService) {
        super(publicKeySupplier, userAccountService, userNamespaceRoleService);
        this.clientId = Objects.requireNonNull(clientId);
        this.configuration = Objects.requireNonNull(suiteOAuthProviderConfiguration);
        this.userAccountService = Objects.requireNonNull(userAccountService);
        this.userNamespaceRoleService = Objects.requireNonNull(userNamespaceRoleService);
    }

    public String getId() {
        return ID;
    }

    public boolean canHandle(Authentication auth) {
        if (!(auth instanceof OAuth2Authentication)) {
            return false;
        }
        OAuth2Authentication oauth2Auth = (OAuth2Authentication)auth;
        if (oauth2Auth.getOAuth2Request() == null) {
            return false;
        }
        return this.clientId.equals(oauth2Auth.getOAuth2Request().getClientId());
    }

    public boolean canHandle(String jwtToken) {
        Optional maybeJwtToken = JwtToken.instance((String)jwtToken);
        return jwtToken != null && jwtToken.trim().length() > 0 && maybeJwtToken.isPresent();
    }

    protected Authentication createAuthentication(HttpServletRequest httpRequest, JwtToken accessToken) {
        return this.authenticate(httpRequest, accessToken.getJwtToken());
    }

    public Authentication authenticate(HttpServletRequest request, String jwtToken) {
        return JwtToken.instance((String)jwtToken).filter(token -> this.verify(request, (JwtToken)token)).map(this::createAuthentication).orElse(null);
    }

    public boolean verify(HttpServletRequest httpRequest, JwtToken jwtToken) {
        if (!this.verifyAlgorithm(jwtToken)) {
            return false;
        }
        if (!super.verifyPublicKey(jwtToken)) {
            return false;
        }
        return super.verifyExpiry(jwtToken);
    }

    private boolean verifyAlgorithm(JwtToken jwtToken) {
        return jwtToken.getHeaderMap().get("alg").equals(RS256_ALG);
    }

    private OAuth2Authentication createAuthentication(JwtToken accessToken) {
        Map tokenPayload = accessToken.getPayloadMap();
        Optional<String> email = Optional.ofNullable((String)tokenPayload.get(EMAIL));
        Optional<String> name = Optional.ofNullable((String)tokenPayload.get("name")).map(str -> str.split("@")[0]);
        String userId = this.getUserId(tokenPayload).orElseThrow(() -> new InvalidTokenException("Cannot generate a userId from your provided token. Maybe 'sub' or 'client_id' is not present in JWT token?"));
        return Optional.ofNullable(this.userAccountService.getUser(userId)).map(user -> this.createAuthentication(this.clientId, userId, name.orElse(userId), email.orElse(null), this.userNamespaceRoleService.getRolesOnAllNamespaces(user))).orElse(null);
    }

    protected String getIssuer() {
        return ID;
    }

    protected Optional<String> getUserId(Map<String, Object> map) {
        try {
            String userId = (String)this.getFromMap(this.getFromMap(map, "ext"), "orig_id").get("sub");
            return Optional.ofNullable(userId);
        }
        catch (CiamIdNotFoundException e) {
            Optional<String> userId = Optional.ofNullable((String)map.get("sub"));
            if (!userId.isPresent()) {
                return Optional.ofNullable((String)map.get("client_id"));
            }
            return userId;
        }
    }

    protected OAuth2Authentication createAuthentication(String clientId, String userId, String name, String email, Set<IRole> roles) {
        UsernamePasswordAuthenticationToken authToken = new UsernamePasswordAuthenticationToken((Object)name, (Object)"N/A", (Collection)SpringUserUtils.toAuthorityList(roles));
        HashMap<String, String> detailsMap = new HashMap<String, String>();
        detailsMap.put("sub", userId);
        detailsMap.put("name", name);
        detailsMap.put(EMAIL, email);
        authToken.setDetails(detailsMap);
        OAuth2Request request = new OAuth2Request(null, clientId, null, true, null, null, null, null, null);
        return new OAuth2Authentication(request, (Authentication)authToken);
    }

    public OAuthUser createUser(Authentication authentication) {
        Authentication userAuthentication;
        OAuthUser user = new OAuthUser();
        user.setUserId(authentication.getName());
        user.setDisplayName(authentication.getName());
        if (authentication instanceof OAuth2Authentication && (userAuthentication = ((OAuth2Authentication)authentication).getUserAuthentication()).getDetails() != null && ((Map)userAuthentication.getDetails()).containsKey(EMAIL)) {
            Map userDetails = (Map)userAuthentication.getDetails();
            if (userDetails.containsKey(EMAIL)) {
                String email = (String)((Map)userAuthentication.getDetails()).get(EMAIL);
                user.setEmail(email);
                user.setDisplayName(email);
            }
            if (userDetails.containsKey(FAMILY_NAME) && userDetails.containsKey(GIVEN_NAME)) {
                user.setDisplayName((String)userDetails.get(GIVEN_NAME) + " " + (String)userDetails.get(FAMILY_NAME));
            }
        }
        HashSet roles = new HashSet();
        authentication.getAuthorities().forEach(e -> roles.add(e.getAuthority()));
        user.setRoles(roles);
        return user;
    }

    public boolean supportsWebflow() {
        return true;
    }

    public Optional<IOAuthFlowConfiguration> getWebflowConfiguration() {
        return Optional.of(this.configuration);
    }

    public String getLabel() {
        return "Bosch IoT SuiteAuth";
    }

    private Map<String, Object> getFromMap(Map<String, Object> map, String key) throws CiamIdNotFoundException {
        if (map.containsKey(key)) {
            return (Map)map.get(key);
        }
        throw new CiamIdNotFoundException();
    }
}

