/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.oauth;

import javax.servlet.http.HttpServletRequest;
import org.eclipse.vorto.repository.oauth.AbstractOAuthProviderConfiguration;
import org.eclipse.vorto.repository.oauth.EidpOAuth2RestTemplate;
import org.eclipse.vorto.repository.oauth.EidpPrincipalExtractor;
import org.eclipse.vorto.repository.oauth.EidpResourceDetails;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.security.oauth2.resource.PrincipalExtractor;
import org.springframework.boot.autoconfigure.security.oauth2.resource.UserInfoTokenServices;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeResourceDetails;

@Configuration
public class BoschIDOAuthProviderConfiguration
extends AbstractOAuthProviderConfiguration {
    @Value(value="${eidp.oauth2.resource.logoutEndpointUrl:#{null}}")
    private String logoutEndpointUrl;
    @Value(value="${eidp.oauth2.resource.logoutRedirectUrl:#{null}}")
    private String logoutRedirectUrl;

    public BoschIDOAuthProviderConfiguration(@Value(value="${eidp.oauth2.resource.userInfoUri}") String endpointUrl, @Value(value="${eidp.oauth2.client.clientId}") String clientId) {
        super(new UserInfoTokenServices(endpointUrl, clientId));
        this.tokenService.setPrincipalExtractor((PrincipalExtractor)new EidpPrincipalExtractor());
    }

    public String getFilterProcessingUrl() {
        return "eidp/login";
    }

    protected String getUserAttributeId() {
        return "sub";
    }

    protected OAuth2RestTemplate createOAuthTemplate() {
        return new EidpOAuth2RestTemplate(this.eidp(), this.oauth2ClientContext);
    }

    @Bean
    @ConfigurationProperties(value="eidp.oauth2.client")
    public EidpResourceDetails eidp() {
        return new EidpResourceDetails();
    }

    protected AuthorizationCodeResourceDetails createDetails() {
        return this.eidp();
    }

    public String getLogoutUrl(HttpServletRequest request) {
        String idToken = (String)this.oauth2ClientContext.getAccessToken().getAdditionalInformation().get("id_token");
        return String.format("%s?id_token_hint=%s&post_logout_redirect_uri=%s", this.logoutEndpointUrl, idToken, this.logoutRedirectUrl);
    }

    public String getLogoHref() {
        return "webjars/repository-web/dist/images/bosch-social.png";
    }
}

