/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.oauth;

import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.vorto.repository.account.impl.DefaultUserAccountService;
import org.eclipse.vorto.repository.domain.User;
import org.eclipse.vorto.repository.oauth.AbstractOAuthProvider;
import org.eclipse.vorto.repository.oauth.BoschIDOAuthProviderConfiguration;
import org.eclipse.vorto.repository.oauth.IOAuthFlowConfiguration;
import org.eclipse.vorto.repository.oauth.OAuthUser;
import org.eclipse.vorto.repository.oauth.internal.JwtToken;
import org.eclipse.vorto.repository.oauth.internal.PublicKeyHelper;
import org.eclipse.vorto.repository.services.UserNamespaceRoleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class BoschIDOAuthProvider
extends AbstractOAuthProvider {
    private String ciamClientId;
    private String ciamJwtIssuer;
    protected static final String JWT_CLIENT_ID = "client_id";
    @Autowired
    private BoschIDOAuthProviderConfiguration configuration;

    @Autowired
    public BoschIDOAuthProvider(@Value(value="${oauth2.verification.eidp.publicKeyUri: #{null}}") String ciamPublicKeyUri, @Value(value="${oauth2.verification.eidp.issuer: #{null}}") String ciamJwtIssuer, @Value(value="${eidp.oauth2.client.clientId: #{null}}") String ciamClientId, @Autowired DefaultUserAccountService userAccountService, @Autowired UserNamespaceRoleService userNamespaceRoleService) {
        super(PublicKeyHelper.supplier((RestTemplate)new RestTemplate(), (String)ciamPublicKeyUri), userAccountService, userNamespaceRoleService);
        this.ciamClientId = ciamClientId;
        this.ciamJwtIssuer = ciamJwtIssuer;
    }

    public boolean canHandle(Authentication auth) {
        if (!(auth instanceof OAuth2Authentication)) {
            return false;
        }
        OAuth2Authentication oauth2Auth = (OAuth2Authentication)auth;
        if (oauth2Auth.getOAuth2Request() == null) {
            return false;
        }
        return this.ciamClientId.equals(oauth2Auth.getOAuth2Request().getClientId());
    }

    public String getIssuer() {
        return this.ciamJwtIssuer;
    }

    public String getId() {
        return "BOSCH-ID";
    }

    public OAuth2Authentication createAuthentication(HttpServletRequest httpRequest, JwtToken accessToken) {
        Map tokenPayload = accessToken.getPayloadMap();
        Optional<String> email = Optional.ofNullable((String)tokenPayload.get("email"));
        Optional<String> name = Optional.ofNullable((String)tokenPayload.get("name")).map(str -> str.split("@")[0]);
        String userId = this.getUserId(tokenPayload).orElseThrow(() -> new InvalidTokenException("Cannot generate a userId from your provided token. Maybe 'sub' or 'client_id' is not present in JWT token?"));
        User user = this.userAccountService.getUser(userId);
        if (user == null) {
            throw new InvalidTokenException("User from token is not a registered user in the repository!");
        }
        return this.createAuthentication(this.ciamClientId, userId, name.orElse(userId), email.orElse(null), this.userNamespaceRoleService.getRolesOnAllNamespaces(user));
    }

    protected Optional<String> getUserId(Map<String, Object> map) {
        Optional<String> userId = Optional.ofNullable((String)map.get("sub"));
        if (!userId.isPresent()) {
            return Optional.ofNullable((String)map.get(JWT_CLIENT_ID));
        }
        return userId;
    }

    public OAuthUser createUser(Authentication authentication) {
        Authentication userAuthentication;
        OAuthUser user = super.createUser(authentication);
        if (authentication instanceof OAuth2Authentication && (userAuthentication = ((OAuth2Authentication)authentication).getUserAuthentication()).getDetails() != null && ((Map)userAuthentication.getDetails()).containsKey("email")) {
            user.setDisplayName(((String)((Map)userAuthentication.getDetails()).get("email")).split("@")[0]);
        }
        return user;
    }

    public boolean supportsWebflow() {
        return true;
    }

    public Optional<IOAuthFlowConfiguration> getWebflowConfiguration() {
        return Optional.of(this.configuration);
    }

    public String getLabel() {
        return "Bosch ID";
    }
}

