/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.api;

public enum ModelType {
    Functionblock(".fbmodel"),
    InformationModel(".infomodel"),
    Datatype(".type"),
    Mapping(".mapping");

    private String extension;

    private ModelType(String extension) {
        this.extension = extension;
    }

    public String getExtension() {
        return this.extension;
    }

    public static ModelType fromFileName(String fileName) {
        String type = fileName.substring(fileName.lastIndexOf("."));
        if (type.equals(Functionblock.getExtension())) {
            return Functionblock;
        }
        if (type.equals(InformationModel.getExtension())) {
            return InformationModel;
        }
        if (type.equals(Datatype.getExtension())) {
            return Datatype;
        }
        if (type.equals(Mapping.getExtension())) {
            return Mapping;
        }
        throw new IllegalArgumentException(fileName);
    }
}

