/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.plugin.generator.adapter;

import java.util.Optional;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.vorto.core.api.model.model.Model;
import org.eclipse.vorto.model.ModelContent;
import org.eclipse.vorto.model.conversion.ModelContentToEcoreConverter;
import org.eclipse.vorto.plugin.generator.GeneratorException;
import org.eclipse.vorto.plugin.generator.ICodeGenerator;
import org.eclipse.vorto.plugin.generator.IGenerationResult;
import org.eclipse.vorto.plugin.generator.InvocationContext;
import org.eclipse.vorto.plugin.utils.Utils;

public class ICodeGeneratorModelAdapter {
    private ICodeGenerator adaptee;
    private ModelContentToEcoreConverter converter;

    public ICodeGeneratorModelAdapter(ICodeGenerator adaptee) {
        this.adaptee = adaptee;
        this.converter = new ModelContentToEcoreConverter();
    }

    public IGenerationResult generate(ModelContent model, InvocationContext context) throws GeneratorException {
        Model convertedModel = this.converter.convert(model, Optional.of(this.adaptee.getMeta().getKey()));
        InformationModel infomodel = Utils.toInformationModel(convertedModel);
        return this.adaptee.generate(infomodel, context);
    }
}

