/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.plugin.generator.utils.javatemplates;

import org.eclipse.emf.common.util.EList;
import org.eclipse.vorto.core.api.model.datatype.Enum;
import org.eclipse.vorto.core.api.model.datatype.EnumLiteral;
import org.eclipse.vorto.plugin.generator.InvocationContext;
import org.eclipse.vorto.plugin.generator.utils.ITemplate;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class JavaEnumTemplate
implements ITemplate<Enum> {
    private String enumPackage;

    public JavaEnumTemplate(String enumPackage) {
        this.enumPackage = enumPackage;
    }

    @Override
    public String getContent(Enum en, InvocationContext invocationContext) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/*");
        _builder.newLine();
        _builder.append("*****************************************************************************************");
        _builder.newLine();
        _builder.append("* The present code has been generated by the Eclipse Vorto Code Generator.");
        _builder.newLine();
        _builder.append("*");
        _builder.newLine();
        _builder.append("* The basis for the generation was the Enum which is uniquely identified by:");
        _builder.newLine();
        _builder.append("* Name:\t\t\t");
        String _name = en.getName();
        _builder.append(_name);
        _builder.newLineIfNotEmpty();
        _builder.append("* Namespace:\t");
        String _namespace = en.getNamespace();
        _builder.append(_namespace);
        _builder.newLineIfNotEmpty();
        _builder.append("* Version:\t\t");
        String _version = en.getVersion();
        _builder.append(_version);
        _builder.newLineIfNotEmpty();
        _builder.append("*****************************************************************************************");
        _builder.newLine();
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("package ");
        _builder.append(this.enumPackage);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append("* ");
        String _description = en.getDescription();
        _builder.append(_description);
        _builder.newLineIfNotEmpty();
        _builder.append("*/");
        _builder.newLine();
        _builder.append("public enum ");
        String _firstUpper = StringExtensions.toFirstUpper((String)en.getName());
        _builder.append(_firstUpper);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        EList _enums = en.getEnums();
        boolean _hasElements = false;
        for (EnumLiteral literal : _enums) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)",", "\t");
            }
            _builder.append("\t");
            _builder.append("/**");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("* ");
            String _description_1 = literal.getDescription();
            _builder.append(_description_1, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("*/");
            _builder.newLine();
            _builder.append("\t");
            String _upperCase = literal.getName().toUpperCase();
            _builder.append(_upperCase, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.newLine();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder.toString();
    }
}

