/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.plugin.generator.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.eclipse.vorto.plugin.generator.IGenerationResult;
import org.eclipse.vorto.plugin.generator.utils.Generated;
import org.eclipse.vorto.plugin.generator.utils.IGeneratedWriter;

public class GenerationResultBuilder {
    private IGenerationResult result;

    private GenerationResultBuilder(IGenerationResult result) {
        this.result = result;
    }

    public static GenerationResultBuilder from(IGenerationResult result) {
        GenerationResultBuilder builder = new GenerationResultBuilder(result);
        return builder;
    }

    public GenerationResultBuilder append(IGenerationResult output) {
        if (output == null) {
            return this;
        }
        this.appendToResult(output.getContent(), (IGeneratedWriter)((Object)this.result));
        return this;
    }

    public IGenerationResult build() {
        return this.result;
    }

    private void appendToResult(byte[] content, IGeneratedWriter result) {
        ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(content));
        try {
            ZipEntry ze = null;
            while ((ze = zis.getNextEntry()) != null) {
                if (ze.isDirectory()) {
                    result.write(new Generated(null, ze.getName(), new byte[0]));
                    continue;
                }
                int indexOfLastSlash = ze.getName().lastIndexOf("/");
                String fileName = null;
                String folderName = null;
                if (indexOfLastSlash > -1) {
                    fileName = ze.getName().substring(indexOfLastSlash + 1);
                    folderName = ze.getName().substring(0, indexOfLastSlash);
                } else {
                    fileName = ze.getName();
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)zis, (OutputStream)baos);
                result.write(new Generated(fileName, folderName, baos.toByteArray()));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (zis != null) {
                try {
                    zis.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

