/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.vorto.model.DefaultMappedElement;
import org.eclipse.vorto.model.IModel;
import org.eclipse.vorto.model.ModelId;
import org.eclipse.vorto.model.ModelType;
import org.eclipse.vorto.model.Stereotype;

public abstract class AbstractModel
extends DefaultMappedElement
implements IModel {
    protected String vortolang;
    protected ModelId id;
    protected ModelType type;
    protected String displayName;
    protected String description;
    protected String category;
    protected String fileName;
    protected String modelType;
    protected List<ModelId> references = new ArrayList<ModelId>();
    private static final String VERSION = "1.0";

    public AbstractModel(ModelId modelId, ModelType modelType) {
        this.vortolang = VERSION;
        this.id = modelId;
        this.type = modelType;
        this.fileName = modelId.getName() + modelType.getExtension();
    }

    public AbstractModel() {
    }

    public String getVortolang() {
        return this.vortolang;
    }

    public void setVortolang(String vortolang) {
        this.vortolang = vortolang;
    }

    @Override
    public ModelId getId() {
        return this.id;
    }

    public void setId(ModelId id) {
        this.id = id;
    }

    @Override
    public ModelType getType() {
        return this.type;
    }

    public void setType(ModelType type) {
        this.type = type;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<ModelId> getReferences() {
        return this.references;
    }

    public void setReferences(List<ModelId> references) {
        this.references = references;
    }

    public String getFileName() {
        return this.fileName;
    }

    @JsonIgnore
    public String getFullQualifiedFileName() {
        return this.id.getPrettyFormat().replace(":", "-").replace("\\.", "_") + this.type.getExtension();
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getModelType() {
        return this.getClass().getSimpleName();
    }

    public static abstract class Builder<T extends AbstractModel> {
        protected T model;

        public Builder(T model) {
            this.model = model;
            this.vortolang(AbstractModel.VERSION);
        }

        public Builder<T> vortolang(String lang) {
            ((AbstractModel)this.model).setVortolang(lang);
            return this;
        }

        public Builder<T> description(String description) {
            ((AbstractModel)this.model).setDescription(description);
            return this;
        }

        public Builder<T> displayname(String displayname) {
            ((AbstractModel)this.model).setDisplayName(displayname);
            return this;
        }

        public Builder<T> reference(ModelId reference) {
            ((AbstractModel)this.model).references.add(reference);
            return this;
        }

        public Builder<T> category(String category) {
            ((AbstractModel)this.model).setCategory(category);
            return this;
        }

        public Builder<T> withStereotype(String stereoTypeName, Map<String, String> attributes, String targetPlatformKey) {
            ((DefaultMappedElement)this.model).setTargetPlatformKey(targetPlatformKey);
            ((DefaultMappedElement)this.model).addStereotype(Stereotype.create(stereoTypeName, attributes));
            return this;
        }

        public Builder<T> withTargetPlatform(String targetPlatformKey) {
            ((DefaultMappedElement)this.model).setTargetPlatformKey(targetPlatformKey);
            return this;
        }

        public T build() {
            return this.model;
        }
    }
}

