/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.vorto.model.AbstractModel;
import org.eclipse.vorto.model.IReferenceType;
import org.eclipse.vorto.model.ModelEvent;
import org.eclipse.vorto.model.ModelId;
import org.eclipse.vorto.model.ModelProperty;
import org.eclipse.vorto.model.ModelType;
import org.eclipse.vorto.model.Operation;

public class FunctionblockModel
extends AbstractModel
implements IReferenceType {
    private List<ModelProperty> configurationProperties = new ArrayList<ModelProperty>();
    private List<ModelProperty> statusProperties = new ArrayList<ModelProperty>();
    private List<ModelProperty> faultProperties = new ArrayList<ModelProperty>();
    private List<ModelEvent> events = new ArrayList<ModelEvent>();
    private List<Operation> operations = new ArrayList<Operation>();

    public FunctionblockModel(ModelId modelId) {
        super(modelId, ModelType.Functionblock);
    }

    protected FunctionblockModel() {
    }

    public static FunctionblockModelBuilder Builder(ModelId id) {
        return new FunctionblockModelBuilder(id);
    }

    public List<ModelProperty> getConfigurationProperties() {
        return this.configurationProperties;
    }

    public void setConfigurationProperties(List<ModelProperty> configurationProperties) {
        this.configurationProperties = configurationProperties;
    }

    public List<ModelProperty> getStatusProperties() {
        return this.statusProperties;
    }

    public Optional<ModelProperty> getStatusProperty(String propertyName) {
        return this.statusProperties.stream().filter(p -> p.getName().equals(propertyName)).findAny();
    }

    public Optional<ModelProperty> getConfigurationProperty(String propertyName) {
        return this.configurationProperties.stream().filter(p -> p.getName().equals(propertyName)).findAny();
    }

    public Optional<ModelProperty> getFaultProperty(String propertyName) {
        return this.faultProperties.stream().filter(p -> p.getName().equals(propertyName)).findAny();
    }

    public void setStatusProperties(List<ModelProperty> statusProperties) {
        this.statusProperties = statusProperties;
    }

    @JsonIgnore
    public List<ModelProperty> getProperties() {
        ArrayList<ModelProperty> properties = new ArrayList<ModelProperty>();
        properties.addAll(this.getStatusProperties());
        properties.addAll(this.getConfigurationProperties());
        return properties;
    }

    @Deprecated
    public List<ModelProperty> getFaultProperties() {
        return this.faultProperties;
    }

    @Deprecated
    public void setFaultProperties(List<ModelProperty> faultProperties) {
        this.faultProperties = faultProperties;
    }

    public List<ModelEvent> getEvents() {
        return this.events;
    }

    public void setEvents(List<ModelEvent> events) {
        this.events = events;
    }

    public List<Operation> getOperations() {
        return this.operations;
    }

    public void setOperations(List<Operation> operations) {
        this.operations = operations;
    }

    public String toString() {
        return "FunctionblockModelDto [configurationProperties=" + this.configurationProperties + ", statusProperties=" + this.statusProperties + ", faultProperties=" + this.faultProperties + ", events=" + this.events + ", operations=" + this.operations + "]";
    }

    public static class FunctionblockModelBuilder
    extends AbstractModel.Builder<FunctionblockModel> {
        private FunctionblockModelBuilder(ModelId id) {
            super(new FunctionblockModel(id));
        }

        public FunctionblockModelBuilder statusProperty(ModelProperty property) {
            ((FunctionblockModel)this.model).getStatusProperties().add(property);
            return this;
        }

        public FunctionblockModelBuilder configurationProperty(ModelProperty property) {
            ((FunctionblockModel)this.model).getConfigurationProperties().add(property);
            return this;
        }

        public FunctionblockModelBuilder event(ModelEvent event) {
            ((FunctionblockModel)this.model).getEvents().add(event);
            return this;
        }

        public FunctionblockModelBuilder operation(Operation operation) {
            ((FunctionblockModel)this.model).getOperations().add(operation);
            return this;
        }
    }
}

