/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Stereotype {
    private String name;
    private static final String SOURCE = "source";
    private static final String TARGET = "target";
    private static final String FUNCTIONS = "functions";
    private static final String XPATH_ATT = "xpath";
    private static final String KEY_ATT = "key";
    private static final String VALUE_ATT = "value";
    private static final String CONDITION_ATT = "condition";
    private Map<String, String> attributes = new HashMap<String, String>();

    public static Stereotype createWithFunction(String functionName, String functionBody) {
        HashMap<String, String> attributes = new HashMap<String, String>(1);
        attributes.put(functionName, functionBody);
        return new Stereotype(FUNCTIONS, attributes);
    }

    public static Stereotype createWithXpath(String xpath) {
        HashMap<String, String> attributes = new HashMap<String, String>(1);
        attributes.put(XPATH_ATT, xpath);
        return new Stereotype(SOURCE, attributes);
    }

    public static Stereotype createOperationTarget(String key, String value) {
        HashMap<String, String> attributes = new HashMap<String, String>(1);
        attributes.put(KEY_ATT, key);
        attributes.put(VALUE_ATT, value);
        return new Stereotype(TARGET, attributes);
    }

    public static Stereotype createTarget() {
        HashMap<String, String> attributes = new HashMap<String, String>(1);
        return new Stereotype(TARGET, attributes);
    }

    public static Stereotype createCondition(String condition) {
        HashMap<String, String> attributes = new HashMap<String, String>(2);
        attributes.put(VALUE_ATT, condition);
        return new Stereotype(CONDITION_ATT, attributes);
    }

    public static Stereotype createWithConditionalXpath(String condition, String xpath) {
        HashMap<String, String> attributes = new HashMap<String, String>(2);
        attributes.put(CONDITION_ATT, condition);
        attributes.put(XPATH_ATT, xpath);
        return new Stereotype(SOURCE, attributes);
    }

    public static Stereotype create(String name, Map<String, String> attributes) {
        return new Stereotype(name, attributes);
    }

    Stereotype(String name, Map<String, String> attributes) {
        this.name = name;
        this.attributes = attributes;
    }

    protected Stereotype() {
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public String toString() {
        return "Stereotype [name=" + this.name + ", attributes=" + this.attributes + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Stereotype other = (Stereotype)obj;
        if (this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public boolean hasAttribute(String attribute) {
        return this.attributes.containsKey(attribute) && !"".equals(this.attributes.get(attribute));
    }
}

