/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.model.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.vorto.model.EntityModel;
import org.eclipse.vorto.model.ModelProperty;
import org.eclipse.vorto.model.runtime.PropertyValue;

public class EntityValue {
    private EntityModel meta;
    private List<PropertyValue> entityProperties = new ArrayList<PropertyValue>();

    public EntityValue(EntityModel meta) {
        this.meta = meta;
    }

    public void withProperty(String name, Object value) {
        Optional<ModelProperty> mp = this.meta.getProperties().stream().filter(p -> p.getName().equals(name)).findFirst();
        if (!mp.isPresent()) {
            throw new IllegalArgumentException("Entity property with given name is not defined");
        }
        this.entityProperties.add(new PropertyValue(mp.get(), value));
    }

    public List<PropertyValue> getProperties() {
        return Collections.unmodifiableList(this.entityProperties);
    }

    public Optional<PropertyValue> getPropertyValue(String name) {
        return this.getProperties().stream().filter(p -> p.getMeta().getName().equals(name)).findAny();
    }

    public EntityModel getMeta() {
        return this.meta;
    }

    public Map<String, Object> serialize() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (PropertyValue entityValue : this.entityProperties) {
            result.put(entityValue.getMeta().getName(), entityValue.getValue());
        }
        return result;
    }
}

