/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.model.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.vorto.model.FunctionblockModel;
import org.eclipse.vorto.model.ModelProperty;
import org.eclipse.vorto.model.PrimitiveType;
import org.eclipse.vorto.model.runtime.IValidatable;
import org.eclipse.vorto.model.runtime.ModelPropertyData;
import org.eclipse.vorto.model.runtime.ValidationReport;

public class FunctionblockData
implements IValidatable {
    private String id;
    private FunctionblockModel meta;
    private List<ModelPropertyData> status = new ArrayList<ModelPropertyData>();
    private List<ModelPropertyData> configuration = new ArrayList<ModelPropertyData>();

    public FunctionblockData(String id, FunctionblockModel meta) {
        this.id = id;
        this.meta = meta;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<ModelPropertyData> getStatus() {
        return Collections.unmodifiableList(this.status);
    }

    public Optional<ModelPropertyData> getStatusProperty(String propertyName) {
        return this.status.stream().filter(p -> p.getPropertyMeta().getName().equals(propertyName)).findAny();
    }

    public List<ModelPropertyData> getConfiguration() {
        return Collections.unmodifiableList(this.status);
    }

    public Optional<ModelPropertyData> getConfigurationProperty(String propertyName) {
        return this.configuration.stream().filter(p -> p.getPropertyMeta().getName().equals(propertyName)).findAny();
    }

    public void withStatusProperty(String name, Object value) {
        Optional mp = this.meta.getStatusProperty(name);
        if (!mp.isPresent()) {
            throw new IllegalArgumentException("Status property with given name is not defined in Function Block");
        }
        this.status.add(new ModelPropertyData((ModelProperty)mp.get(), value));
    }

    public void withConfigurationProperty(String name, Object value) {
        Optional mp = this.meta.getConfigurationProperty(name);
        if (!mp.isPresent()) {
            throw new IllegalArgumentException("Configuration property with given name is not defined in Function Block");
        }
        this.configuration.add(new ModelPropertyData((ModelProperty)mp.get(), value));
    }

    public String toString() {
        return "FunctionblockData [id=" + this.id + ", status=" + this.status + ", configuration=" + this.configuration + "]";
    }

    @Override
    public ValidationReport validate() {
        ValidationReport report = new ValidationReport();
        for (ModelProperty statusProperty : this.meta.getStatusProperties()) {
            this.checkProperty(this.getStatus(), statusProperty, this.id + "/status", report);
        }
        for (ModelProperty configProperty : this.meta.getConfigurationProperties()) {
            this.checkProperty(this.getConfiguration(), configProperty, this.id + "/configuration", report);
        }
        return report;
    }

    private void checkProperty(List<ModelPropertyData> properties, ModelProperty property, String path, ValidationReport report) {
        Optional<ModelPropertyData> mpd = properties.stream().filter(p -> p.getPropertyMeta().equals((Object)property)).findAny();
        if (property.isMandatory() && !mpd.isPresent()) {
            report.addItem(property, "Mandatory field " + path + "/" + property.getName() + " is missing");
        } else if (mpd.isPresent() && property.getType() instanceof PrimitiveType) {
            FunctionblockData.checkPrimitiveTypeValue(path, mpd.get().getValue(), property, report);
        }
    }

    private static void checkPrimitiveTypeValue(String path, Object propertyValue, ModelProperty property, ValidationReport report) {
        PrimitiveType type = (PrimitiveType)property.getType();
        if (type == PrimitiveType.STRING && !(propertyValue instanceof String)) {
            report.addItem(property, "Field " + path + "/" + property.getName() + " must be of type 'String'");
        } else if (type == PrimitiveType.BOOLEAN && !(propertyValue instanceof Boolean)) {
            report.addItem(property, "Field " + path + "/" + property.getName() + " must be of type 'Boolean'");
        } else if (type == PrimitiveType.DOUBLE && !(propertyValue instanceof Double)) {
            report.addItem(property, "Field " + path + "/" + property.getName() + " must be of type 'Double'");
        } else if (type == PrimitiveType.FLOAT && !FunctionblockData.isFloat(propertyValue)) {
            report.addItem(property, "Field " + path + "/" + property.getName() + " must be of type 'Float'");
        } else if (type == PrimitiveType.INT && !FunctionblockData.isInteger(propertyValue)) {
            report.addItem(property, "Field " + path + "/" + property.getName() + " must be of type 'Integer'");
        } else if (type == PrimitiveType.LONG && !FunctionblockData.isLong(propertyValue)) {
            report.addItem(property, "Field " + path + "/" + property.getName() + " must be of type 'Long'");
        } else if (type == PrimitiveType.BASE64_BINARY && !(propertyValue instanceof String)) {
            report.addItem(property, "Field " + path + "/" + property.getName() + " must be a Base64-encoded 'String'");
        }
    }

    private static boolean isInteger(Object value) {
        try {
            Integer.parseInt(value.toString());
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    private static boolean isFloat(Object value) {
        try {
            Float.parseFloat(value.toString());
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    private static boolean isLong(Object value) {
        try {
            Long.parseLong(value.toString());
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    public Map<String, Object> serialize() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, Object> statusProperties = new HashMap<String, Object>();
        for (ModelPropertyData statusProperty : this.status) {
            statusProperties.put(statusProperty.getPropertyMeta().getName(), statusProperty.getValue());
        }
        result.put("status", statusProperties);
        HashMap<String, Object> configuration = new HashMap<String, Object>();
        for (ModelPropertyData configProperty : this.configuration) {
            configuration.put(configProperty.getPropertyMeta().getName(), configProperty.getValue());
        }
        if (!configuration.isEmpty()) {
            result.put("configuration", configuration);
        }
        return result;
    }
}

