/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.model.refactor;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.vorto.core.api.model.model.Model;
import org.eclipse.vorto.core.api.model.model.ModelId;
import org.eclipse.vorto.core.api.model.model.ModelIdFactory;
import org.eclipse.vorto.model.refactor.ChangeSet;
import org.eclipse.vorto.utilities.reader.IModelWorkspace;

public class RefactoringTask {
    private IModelWorkspace workspace;
    private Set<Model> changedModels = new HashSet<Model>();

    private RefactoringTask(IModelWorkspace workspace) {
        this.workspace = workspace;
    }

    public static RefactoringTask from(IModelWorkspace workspace) {
        return new RefactoringTask(workspace);
    }

    public RefactoringTask toNamespaceForAllModels(String targetNamespace, String ... ignoredNamespaces) {
        HashSet<String> ignoreNamespaceList = new HashSet<String>();
        if (ignoredNamespaces != null) {
            ignoreNamespaceList.addAll(Arrays.asList(ignoredNamespaces));
        }
        this.workspace.get().forEach(model -> {
            String oldNamespace = model.getNamespace();
            if (!ignoreNamespaceList.contains(oldNamespace) && !model.getNamespace().startsWith(targetNamespace)) {
                String newNamespace = targetNamespace + "." + oldNamespace;
                model.setNamespace(newNamespace);
                ModelId newModelId = ModelIdFactory.newInstance((Model)model);
                ModelId oldModelId = new ModelId(newModelId.getModelType(), newModelId.getName(), oldNamespace, newModelId.getVersion());
                this.updateReferences(oldModelId, newModelId);
                this.changedModels.add((Model)model);
            }
        });
        return this;
    }

    public RefactoringTask toModelId(ModelId oldModelId, ModelId newModelId) {
        this.workspace.get().forEach(model -> {
            ModelId currentModelId = ModelIdFactory.newInstance((Model)model);
            if (currentModelId.equals((Object)oldModelId)) {
                model.setName(newModelId.getName());
                model.setVersion(newModelId.getVersion());
                model.setNamespace(newModelId.getNamespace());
                this.updateReferences(oldModelId, newModelId);
                this.changedModels.add((Model)model);
            }
        });
        return this;
    }

    private void updateReferences(ModelId oldId, ModelId newId) {
        this.workspace.get().forEach(model -> model.getReferences().stream().forEach(reference -> {
            if (reference.getImportedNamespace().equals(oldId.getNamespace() + "." + oldId.getName()) && reference.getVersion().equals(oldId.getVersion())) {
                reference.setImportedNamespace(newId.getNamespace() + "." + newId.getName());
                reference.setVersion(newId.getVersion());
                this.changedModels.add((Model)model);
            }
        }));
    }

    public ChangeSet execute() {
        return new ChangeSet(this.workspace, this.changedModels);
    }
}

