/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.service.mapping.internal.cc;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.jxpath.JXPathContext;
import org.eclipse.vorto.repository.api.content.FunctionblockModel;
import org.eclipse.vorto.repository.api.content.Infomodel;
import org.eclipse.vorto.repository.api.content.ModelProperty;
import org.eclipse.vorto.repository.api.content.Operation;
import org.eclipse.vorto.repository.api.content.Param;
import org.eclipse.vorto.repository.api.content.Stereotype;
import org.eclipse.vorto.service.mapping.DataInput;
import org.eclipse.vorto.service.mapping.IDataMapper;
import org.eclipse.vorto.service.mapping.MappingContext;
import org.eclipse.vorto.service.mapping.internal.DynamicBean;
import org.eclipse.vorto.service.mapping.internal.JxPathFactory;
import org.eclipse.vorto.service.mapping.json.JsonData;
import org.eclipse.vorto.service.mapping.normalized.Command;
import org.eclipse.vorto.service.mapping.spec.IMappingSpecification;

public class CommandMapper
implements IDataMapper<JsonData> {
    private IMappingSpecification mappingSpecification;
    private static final String STEREOTYPE = "target";
    private static final String ATTRIBUTE_XPATH = "key";
    private static final String ATTRIBUTE_VALUE = "value";
    private JxPathFactory jxpathFactory = null;

    public CommandMapper(IMappingSpecification specification) {
        this.mappingSpecification = specification;
        this.jxpathFactory = new JxPathFactory(specification.getCustomFunctions());
        this.jxpathFactory.setLenient(true);
    }

    @Override
    public JsonData map(DataInput input, MappingContext context) {
        Command cmd = (Command)input.getValue();
        DynamicBean mappedPayload = new DynamicBean(this.jxpathFactory);
        Infomodel deviceInfoModel = this.mappingSpecification.getInfoModel();
        for (ModelProperty fbProperty : deviceInfoModel.getFunctionblocks()) {
            FunctionblockModel fbModel = this.mappingSpecification.getFunctionBlock(fbProperty.getName());
            for (Operation operation : fbModel.getOperations()) {
                Optional operationStereotype = operation.getStereotype(STEREOTYPE);
                if (operationStereotype.isPresent() && this.hasXpath(((Stereotype)operationStereotype.get()).getAttributes())) {
                    String expression = (String)((Stereotype)operationStereotype.get()).getAttributes().get(ATTRIBUTE_XPATH);
                    String value = (String)((Stereotype)operationStereotype.get()).getAttributes().get(ATTRIBUTE_VALUE);
                    mappedPayload.setProperty(expression, value);
                }
                operation.getParams().stream().forEach(param -> param.getStereotypes().stream().filter(s -> s.getName().equals(STEREOTYPE)).forEach(paramStereotype -> {
                    if (this.hasXpath(paramStereotype.getAttributes())) {
                        String expression = (String)paramStereotype.getAttributes().get(ATTRIBUTE_XPATH);
                        Object value = this.replacePlaceHolders((String)paramStereotype.getAttributes().get(ATTRIBUTE_VALUE), (Param)param, cmd.getParams());
                        mappedPayload.setProperty(expression, value);
                    }
                }));
            }
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            final ByteArrayOutputStream baos = new ByteArrayOutputStream();
            mapper.writeValue((OutputStream)baos, mappedPayload.asMap());
            return new JsonData(){

                @Override
                public String toJson() {
                    return new String(baos.toByteArray());
                }
            };
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Provided json not valid");
        }
    }

    private Object replacePlaceHolders(String expression, Param param, Map<String, Object> values) {
        JXPathContext jxpathCtx = this.jxpathFactory.newContext(values);
        return jxpathCtx.getValue(expression);
    }

    private boolean hasXpath(Map<String, String> stereotypeAttributes) {
        return stereotypeAttributes.containsKey(ATTRIBUTE_XPATH) && !stereotypeAttributes.get(ATTRIBUTE_XPATH).equals("");
    }
}

