/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.hono.python;

import com.google.common.base.Objects;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.vorto.codegen.api.IFileTemplate;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.core.api.model.datatype.PrimitivePropertyType;
import org.eclipse.vorto.core.api.model.datatype.PrimitiveType;
import org.eclipse.vorto.core.api.model.datatype.Property;
import org.eclipse.vorto.core.api.model.datatype.PropertyType;
import org.eclipse.vorto.core.api.model.functionblock.Configuration;
import org.eclipse.vorto.core.api.model.functionblock.FunctionBlock;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.functionblock.Status;
import org.eclipse.vorto.core.api.model.informationmodel.FunctionblockProperty;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class PythonSampleTemplate
implements IFileTemplate<InformationModel> {
    public String getFileName(InformationModel model) {
        String _name = model.getName();
        return _name + "App.py";
    }

    public String getPath(InformationModel model) {
        return "";
    }

    public String getContent(InformationModel model, InvocationContext context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"import netifaces");
        _builder.newLine();
        _builder.append((Object)"import paho.mqtt.client as mqtt");
        _builder.newLine();
        _builder.append((Object)"import datetime, threading, time");
        _builder.newLine();
        EList _properties = model.getProperties();
        for (FunctionblockProperty fb : _properties) {
            _builder.append((Object)"import model.functionblock.");
            FunctionblockModel _type = fb.getType();
            String _name = _type.getName();
            _builder.append((Object)_name, "");
            _builder.append((Object)" as ");
            String _name_1 = fb.getName();
            _builder.append((Object)_name_1, "");
            _builder.append((Object)" ");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"import model.infomodel.");
        String _name_2 = model.getName();
        _builder.append((Object)_name_2, "");
        _builder.append((Object)" as ");
        String _name_3 = model.getName();
        _builder.append((Object)_name_3, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"import model.DittoSerializer as DittoSerializer");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"# DEVICE CONFIG GOES HERE");
        _builder.newLine();
        _builder.append((Object)"hono_tenant = \"");
        Map _configurationProperties = context.getConfigurationProperties();
        String _orDefault = _configurationProperties.getOrDefault("hono_tenant", "<hono_tenant>");
        _builder.append((Object)_orDefault, "");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"hono_password = \"<ADD PASSWORD HERE>\"");
        _builder.newLine();
        _builder.append((Object)"hono_endpoint = \"");
        Map _configurationProperties_1 = context.getConfigurationProperties();
        String _orDefault_1 = _configurationProperties_1.getOrDefault("hono_endpoint", "<hono_endpoint>");
        _builder.append((Object)_orDefault_1, "");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"hono_deviceId = \"");
        Map _configurationProperties_2 = context.getConfigurationProperties();
        String _orDefault_2 = _configurationProperties_2.getOrDefault("hono_deviceId", "<hono_deviceId>");
        _builder.append((Object)_orDefault_2, "");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"hono_clientId = hono_deviceId");
        _builder.newLine();
        _builder.append((Object)"hono_authId = hono_deviceId + \"@\" + hono_tenant");
        _builder.newLine();
        _builder.append((Object)"hono_certificatePath = \"<ADD PATH TO CERTIFICATE HERE>\"");
        _builder.newLine();
        _builder.append((Object)"ditto_namespace = \"");
        Map _configurationProperties_3 = context.getConfigurationProperties();
        String _orDefault_3 = _configurationProperties_3.getOrDefault("ditto_namespace", "com.mycompany");
        _builder.append((Object)_orDefault_3, "");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"# The callback for when the client receives a CONNACK response from the server.");
        _builder.newLine();
        _builder.append((Object)"def on_connect(client, userdata, flags, rc):");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"global next_call");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"if rc != 0:");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"print(\"Connection to MQTT broker failed: \" + str(rc))");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"return");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"# Subscribing in on_connect() means that if we lose the connection and");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"# reconnect then subscriptions will be renewed.");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"# BEGIN SAMPLE CODE");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"client.subscribe(\"commands/\" + hono_tenant + \"/\")");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"# END SAMPLE CODE");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"# Time stamp when the periodAction function shall be called again");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"next_call = time.time()");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"# Start the periodic task for publishing MQTT messages");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"periodicAction()");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"# The callback for when a PUBLISH message is received from the server.");
        _builder.newLine();
        _builder.append((Object)"def on_message(client, userdata, msg):");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"### BEGIN SAMPLE CODE");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"print(msg.topic+\" \"+str(msg.payload))");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"### END SAMPLE CODE");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"# The functions to publish the functionblocks data");
        _builder.newLine();
        EList _properties_1 = model.getProperties();
        for (FunctionblockProperty fb_1 : _properties_1) {
            _builder.append((Object)"def publish");
            String _name_4 = fb_1.getName();
            String _firstUpper = StringExtensions.toFirstUpper((String)_name_4);
            _builder.append((Object)_firstUpper, "");
            _builder.append((Object)"():");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"payload = ser.serialize_functionblock(\"");
            String _name_5 = fb_1.getName();
            _builder.append((Object)_name_5, "    ");
            _builder.append((Object)"\", infomodel.");
            String _name_6 = fb_1.getName();
            _builder.append((Object)_name_6, "    ");
            _builder.append((Object)", ditto_namespace, hono_deviceId)");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"print(\"Publish Payload: \", payload, \" to Topic: \", publishTopic)");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"client.publish(publishTopic, payload)");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.newLine();
        }
        _builder.append((Object)"# The function that will be executed periodically once the connection to the MQTT broker was established");
        _builder.newLine();
        _builder.append((Object)"def periodicAction():");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"global next_call");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"### BEGIN SAMPLE CODE");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"# Setting properties of function blocks");
        _builder.newLine();
        EList _properties_2 = model.getProperties();
        for (FunctionblockProperty fb_2 : _properties_2) {
            FunctionblockModel _type_1 = fb_2.getType();
            FunctionBlock _functionblock = _type_1.getFunctionblock();
            Status _status = _functionblock.getStatus();
            boolean _tripleNotEquals = _status != null;
            if (!_tripleNotEquals) continue;
            FunctionblockModel _type_2 = fb_2.getType();
            FunctionBlock _functionblock_1 = _type_2.getFunctionblock();
            Status _status_1 = _functionblock_1.getStatus();
            EList _properties_3 = _status_1.getProperties();
            for (Property status : _properties_3) {
                PropertyType _type_3 = status.getType();
                if (!(_type_3 instanceof PrimitivePropertyType)) continue;
                _builder.append((Object)"    ");
                PropertyType _type_4 = status.getType();
                PrimitivePropertyType primitiveType = (PrimitivePropertyType)_type_4;
                _builder.newLineIfNotEmpty();
                PrimitiveType _type_5 = primitiveType.getType();
                boolean _equals = Objects.equal((Object)_type_5, (Object)PrimitiveType.STRING);
                if (_equals) {
                    _builder.append((Object)"    ");
                    _builder.append((Object)"infomodel.");
                    String _name_7 = fb_2.getName();
                    _builder.append((Object)_name_7, "    ");
                    _builder.append((Object)".");
                    String _name_8 = status.getName();
                    _builder.append((Object)_name_8, "    ");
                    _builder.append((Object)" = \"\"");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                _builder.append((Object)"    ");
                _builder.append((Object)"infomodel.");
                String _name_9 = fb_2.getName();
                _builder.append((Object)_name_9, "    ");
                _builder.append((Object)".");
                String _name_10 = status.getName();
                _builder.append((Object)_name_10, "    ");
                _builder.append((Object)" += 1");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"### END SAMPLE CODE");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"# Publish payload");
        _builder.newLine();
        EList _properties_4 = model.getProperties();
        for (FunctionblockProperty fb_3 : _properties_4) {
            _builder.append((Object)"    ");
            _builder.append((Object)"publish");
            String _name_11 = fb_3.getName();
            String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_11);
            _builder.append((Object)_firstUpper_1, "    ");
            _builder.append((Object)"()");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"# Schedule next call");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"next_call = next_call + timePeriod;");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"threading.Timer(next_call - time.time(), periodicAction).start()");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"# Initialization of Information Model ");
        _builder.newLine();
        _builder.append((Object)"infomodel = ");
        String _name_12 = model.getName();
        _builder.append((Object)_name_12, "");
        _builder.append((Object)".");
        String _name_13 = model.getName();
        _builder.append((Object)_name_13, "");
        _builder.append((Object)"()");
        _builder.newLineIfNotEmpty();
        EList _properties_5 = model.getProperties();
        for (FunctionblockProperty fb_4 : _properties_5) {
            FunctionblockModel _type_11;
            FunctionBlock _functionblock_4;
            Configuration _configuration;
            boolean _tripleNotEquals_2;
            boolean _tripleNotEquals_1;
            FunctionblockModel _type_6 = fb_4.getType();
            FunctionBlock _functionblock_2 = _type_6.getFunctionblock();
            Status _status_2 = _functionblock_2.getStatus();
            boolean bl = _tripleNotEquals_1 = _status_2 != null;
            if (_tripleNotEquals_1) {
                FunctionblockModel _type_7 = fb_4.getType();
                FunctionBlock _functionblock_3 = _type_7.getFunctionblock();
                Status _status_3 = _functionblock_3.getStatus();
                EList _properties_6 = _status_3.getProperties();
                for (Property status_1 : _properties_6) {
                    PropertyType _type_8 = status_1.getType();
                    if (!(_type_8 instanceof PrimitivePropertyType)) continue;
                    PropertyType _type_9 = status_1.getType();
                    PrimitivePropertyType primitiveType_1 = (PrimitivePropertyType)_type_9;
                    _builder.newLineIfNotEmpty();
                    PrimitiveType _type_10 = primitiveType_1.getType();
                    boolean _equals_1 = Objects.equal((Object)_type_10, (Object)PrimitiveType.STRING);
                    if (_equals_1) {
                        _builder.append((Object)"infomodel.");
                        String _name_14 = fb_4.getName();
                        _builder.append((Object)_name_14, "");
                        _builder.append((Object)".");
                        String _name_15 = status_1.getName();
                        _builder.append((Object)_name_15, "");
                        _builder.append((Object)" = \"\"");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    _builder.append((Object)"infomodel.");
                    String _name_16 = fb_4.getName();
                    _builder.append((Object)_name_16, "");
                    _builder.append((Object)".");
                    String _name_17 = status_1.getName();
                    _builder.append((Object)_name_17, "");
                    _builder.append((Object)" = 0");
                    _builder.newLineIfNotEmpty();
                }
            }
            if (!(_tripleNotEquals_2 = (_configuration = (_functionblock_4 = (_type_11 = fb_4.getType()).getFunctionblock()).getConfiguration()) != null)) continue;
            FunctionblockModel _type_12 = fb_4.getType();
            FunctionBlock _functionblock_5 = _type_12.getFunctionblock();
            Configuration _configuration_1 = _functionblock_5.getConfiguration();
            EList _properties_7 = _configuration_1.getProperties();
            for (Property configuration : _properties_7) {
                PropertyType _type_13 = configuration.getType();
                if (!(_type_13 instanceof PrimitivePropertyType)) continue;
                PropertyType _type_14 = configuration.getType();
                PrimitivePropertyType primitiveType_2 = (PrimitivePropertyType)_type_14;
                _builder.newLineIfNotEmpty();
                PrimitiveType _type_15 = primitiveType_2.getType();
                boolean _equals_2 = Objects.equal((Object)_type_15, (Object)PrimitiveType.STRING);
                if (_equals_2) {
                    _builder.append((Object)"infomodel.");
                    String _name_18 = fb_4.getName();
                    _builder.append((Object)_name_18, "");
                    _builder.append((Object)".");
                    String _name_19 = configuration.getName();
                    _builder.append((Object)_name_19, "");
                    _builder.append((Object)" = \"\"");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                _builder.append((Object)"infomodel.");
                String _name_20 = fb_4.getName();
                _builder.append((Object)_name_20, "");
                _builder.append((Object)".");
                String _name_21 = configuration.getName();
                _builder.append((Object)_name_21, "");
                _builder.append((Object)" = 0");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        _builder.append((Object)"# Create a serializer for the MQTT payload from the Information Model");
        _builder.newLine();
        _builder.append((Object)"ser = DittoSerializer.DittoSerializer()");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"# Timer variable for periodic function");
        _builder.newLine();
        _builder.append((Object)"next_call = 0");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"# Period for publishing data to the MQTT broker in seconds");
        _builder.newLine();
        _builder.append((Object)"timePeriod = 10");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"# Configuration of client ID and publish topic\t");
        _builder.newLine();
        _builder.append((Object)"publishTopic = \"telemetry/\" + hono_tenant + \"/\" + hono_clientId");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"# Output relevant information for consumers of our information");
        _builder.newLine();
        _builder.append((Object)"print(\"Connecting client:    \", hono_clientId)");
        _builder.newLine();
        _builder.append((Object)"print(\"Publishing to topic:  \", publishTopic)");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"# Create the MQTT client");
        _builder.newLine();
        _builder.append((Object)"client = mqtt.Client(hono_clientId)");
        _builder.newLine();
        _builder.append((Object)"client.on_connect = on_connect");
        _builder.newLine();
        _builder.append((Object)"client.on_message = on_message");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"client.tls_set(hono_certificatePath)");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"client.username_pw_set(hono_authId, hono_password)");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"# Connect to the MQTT broker");
        _builder.newLine();
        _builder.append((Object)"client.connect(hono_endpoint, 8883, 60)");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"# Blocking call that processes network traffic, dispatches callbacks and");
        _builder.newLine();
        _builder.append((Object)"# handles reconnecting.");
        _builder.newLine();
        _builder.append((Object)"# Other loop*() functions are available that give a threaded interface and a");
        _builder.newLine();
        _builder.append((Object)"# manual interface.");
        _builder.newLine();
        _builder.append((Object)"client.loop_start()");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"while (1):");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"pass");
        _builder.newLine();
        return _builder.toString();
    }
}

