/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.hono.java.service.hono;

import org.eclipse.vorto.codegen.api.IFileTemplate;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.hono.java.Utils;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.xtend2.lib.StringConcatenation;

public class HonoMqttClientTemplate
implements IFileTemplate<InformationModel> {
    public String getFileName(InformationModel context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"HonoMqttClient.java");
        return _builder.toString();
    }

    public String getPath(InformationModel context) {
        StringConcatenation _builder = new StringConcatenation();
        String _javaPackageBasePath = Utils.getJavaPackageBasePath(context);
        _builder.append((Object)_javaPackageBasePath, "");
        _builder.append((Object)"/service/hono");
        return _builder.toString();
    }

    public String getContent(InformationModel element, InvocationContext context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package ");
        String _javaPackage = Utils.getJavaPackage(element);
        _builder.append((Object)_javaPackage, "");
        _builder.append((Object)".service.hono;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import java.io.BufferedInputStream;");
        _builder.newLine();
        _builder.append((Object)"import java.io.IOException;");
        _builder.newLine();
        _builder.append((Object)"import java.io.InputStream;");
        _builder.newLine();
        _builder.append((Object)"import java.net.URL;");
        _builder.newLine();
        _builder.append((Object)"import java.security.KeyManagementException;");
        _builder.newLine();
        _builder.append((Object)"import java.security.KeyStore;");
        _builder.newLine();
        _builder.append((Object)"import java.security.KeyStoreException;");
        _builder.newLine();
        _builder.append((Object)"import java.security.NoSuchAlgorithmException;");
        _builder.newLine();
        _builder.append((Object)"import java.security.cert.Certificate;");
        _builder.newLine();
        _builder.append((Object)"import java.security.cert.CertificateException;");
        _builder.newLine();
        _builder.append((Object)"import java.security.cert.CertificateFactory;");
        _builder.newLine();
        _builder.append((Object)"import java.util.Objects;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import javax.net.ssl.SSLContext;");
        _builder.newLine();
        _builder.append((Object)"import javax.net.ssl.SSLSocketFactory;");
        _builder.newLine();
        _builder.append((Object)"import javax.net.ssl.TrustManagerFactory;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import org.apache.log4j.Logger;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.paho.client.mqttv3.IMqttActionListener;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.paho.client.mqttv3.IMqttToken;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.paho.client.mqttv3.MqttClient;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.paho.client.mqttv3.MqttConnectOptions;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.paho.client.mqttv3.MqttException;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* MQTTv3 Client based on Eclipse Paho ");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"public class HonoMqttClient {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private static final Logger logger = Logger.getLogger(HonoMqttClient.class);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private static final URL CERTIFICATE_LOCATION = HonoMqttClient.class.getResource(\"/certificate/hono.crt\");");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private String mqttHostUrl;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private String clientId;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private MqttClient mqttClient = null;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private MqttConnectOptions connOpts = null;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public HonoMqttClient(String mqttHostUrl, String clientId, String authId, String password) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.mqttHostUrl = Objects.requireNonNull(mqttHostUrl);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.clientId = Objects.requireNonNull(clientId);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"logger.info(String.format(\"Creating Hub Client for [%s] with Client Id [%s]\", mqttHostUrl, clientId));");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"mqttClient = new MqttClient(mqttHostUrl, clientId, new MemoryPersistence());");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"connOpts = new MqttConnectOptions();");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"connOpts.setUserName(authId);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"connOpts.setPassword(password.toCharArray());");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"connOpts.setSocketFactory(buildSslSocketFactory(CERTIFICATE_LOCATION));");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"} catch (MqttException e) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"logger.error(\"Exception connecting to Hono\", e);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new RuntimeException(e);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void connect() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"logger.info(\"Connecting to Hono.\");");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"IMqttToken token = mqttClient.connectWithResult(connOpts);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"token.setActionCallback(new IMqttActionListener() {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"public void onFailure(IMqttToken arg0, Throwable arg1) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"logger.error(\"Failed to connect to Hono [\" + mqttHostUrl + \", \" + clientId + \"]\", arg1);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"public void onSuccess(IMqttToken arg0) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"logger.info(\"Connected to Hono [\" + mqttHostUrl + \", \" + clientId + \"]\");");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"});");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"logger.info(\"Hono Client CONNECTED.\");");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"} catch (MqttException e) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new RuntimeException(e);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void send(String topic, String message) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (mqttClient != null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"if (mqttClient.isConnected()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"logger.info(String.format(\"Sending topic [%s] message [%s]\", topic, message));");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"mqttClient.publish(topic, message.getBytes(), 0, false);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"logger.info(String.format(\"Send done.\"));");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"} catch (MqttException e) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"logger.error(\"MQTT Client has error in sending message.\", e);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"} else {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"logger.error(\"Mqtt Client is not connected.\");");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"throw new RuntimeException(\"MQTT Client is not connected.\");");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"} else {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"logger.error(\"Mqtt Client is not initialized.\");");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new RuntimeException(\"MQTT Client is not initialized.\");");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public boolean isConnected() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return mqttClient != null && mqttClient.isConnected();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private static SSLSocketFactory buildSslSocketFactory(URL certificateUrl) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"CertificateFactory certFactory = CertificateFactory.getInstance(\"X.509\");");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"InputStream certificateInputstream = new BufferedInputStream(Objects.requireNonNull(certificateUrl).openStream());");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"Certificate certificate;");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"certificate = certFactory.generateCertificate(certificateInputstream);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"} finally {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"certificateInputstream.close();");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"// Create a KeyStore containing our trusted CAs");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"keyStore.load(null, null);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"keyStore.setCertificateEntry(\"ca\", certificate);");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"// Create a TrustManager that trusts the CAs in our KeyStore");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"tmf.init(keyStore);");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"// Create an SSLContext that uses our TrustManager");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"SSLContext context = SSLContext.getInstance(\"TLS\");");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"context.init(null, tmf.getTrustManagers(), null);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return context.getSocketFactory();");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"} catch (NoSuchAlgorithmException | KeyStoreException | KeyManagementException | CertificateException | IOException e) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"logger.error(\"Error building ssl socket factory\", e);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return null;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        return _builder.toString();
    }
}

