/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.hono.java;

import java.util.Arrays;
import java.util.List;
import org.eclipse.vorto.core.api.model.datatype.ObjectPropertyType;
import org.eclipse.vorto.core.api.model.datatype.PrimitivePropertyType;
import org.eclipse.vorto.core.api.model.datatype.PrimitiveType;
import org.eclipse.vorto.core.api.model.datatype.PropertyType;

public class TypeMapper {
    static final List<String> keywords = Arrays.asList("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while");

    public static String mapSimpleDatatype(PropertyType type) {
        if (type instanceof ObjectPropertyType) {
            return "String";
        }
        PrimitivePropertyType primitiveType = (PrimitivePropertyType)type;
        if (primitiveType.getType().compareTo((Enum)PrimitiveType.STRING) == 0) {
            return "String";
        }
        if (primitiveType.getType().compareTo((Enum)PrimitiveType.DATETIME) == 0) {
            return "java.util.Date";
        }
        return primitiveType.getType().getLiteral();
    }

    public static String getRandomValue(PropertyType type) {
        if (type instanceof ObjectPropertyType) {
            return "\"\"";
        }
        PrimitivePropertyType primitiveType = (PrimitivePropertyType)type;
        if (primitiveType.getType().compareTo((Enum)PrimitiveType.STRING) == 0) {
            return "\"\"";
        }
        if (primitiveType.getType().compareTo((Enum)PrimitiveType.BOOLEAN) == 0) {
            return "new java.util.Random().nextBoolean()";
        }
        if (primitiveType.getType().compareTo((Enum)PrimitiveType.INT) == 0) {
            return "new java.util.Random().nextInt(100)";
        }
        if (primitiveType.getType().compareTo((Enum)PrimitiveType.FLOAT) == 0) {
            return "Math.round(new java.util.Random().nextFloat()*(float)100)";
        }
        if (primitiveType.getType().compareTo((Enum)PrimitiveType.DOUBLE) == 0) {
            return "Math.round(new java.util.Random().nextDouble()*(double)100)";
        }
        if (primitiveType.getType().compareTo((Enum)PrimitiveType.DATETIME) == 0) {
            return "new java.util.Date()";
        }
        if (primitiveType.getType().compareTo((Enum)PrimitiveType.SHORT) == 0) {
            return "new java.util.Random().nextInt(100)";
        }
        if (primitiveType.getType().compareTo((Enum)PrimitiveType.BASE64_BINARY) == 0) {
            return "null";
        }
        if (primitiveType.getType().compareTo((Enum)PrimitiveType.BYTE) == 0) {
            return "(byte) new java.util.Random().nextInt(100)";
        }
        return "";
    }

    public static String checkKeyword(String name) {
        return keywords.contains(name) ? name + "_" : name;
    }
}

