/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.hono.java.service.hono;

import org.eclipse.vorto.codegen.api.IFileTemplate;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.hono.java.Utils;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.xtend2.lib.StringConcatenation;

public class HonoMqttClientTemplate
implements IFileTemplate<InformationModel> {
    public String getFileName(InformationModel context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("HonoMqttClient.java");
        return _builder.toString();
    }

    public String getPath(InformationModel context) {
        StringConcatenation _builder = new StringConcatenation();
        String _javaPackageBasePath = Utils.getJavaPackageBasePath(context);
        _builder.append(_javaPackageBasePath);
        _builder.append("/service/hono");
        return _builder.toString();
    }

    public String getContent(InformationModel element, InvocationContext context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        String _javaPackage = Utils.getJavaPackage(element);
        _builder.append(_javaPackage);
        _builder.append(".service.hono;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import java.io.BufferedInputStream;");
        _builder.newLine();
        _builder.append("import java.io.IOException;");
        _builder.newLine();
        _builder.append("import java.io.InputStream;");
        _builder.newLine();
        _builder.append("import java.net.URL;");
        _builder.newLine();
        _builder.append("import java.security.KeyManagementException;");
        _builder.newLine();
        _builder.append("import java.security.KeyStore;");
        _builder.newLine();
        _builder.append("import java.security.KeyStoreException;");
        _builder.newLine();
        _builder.append("import java.security.NoSuchAlgorithmException;");
        _builder.newLine();
        _builder.append("import java.security.cert.Certificate;");
        _builder.newLine();
        _builder.append("import java.security.cert.CertificateException;");
        _builder.newLine();
        _builder.append("import java.security.cert.CertificateFactory;");
        _builder.newLine();
        _builder.append("import java.util.Objects;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("import javax.net.ssl.SSLContext;");
        _builder.newLine();
        _builder.append("import javax.net.ssl.SSLSocketFactory;");
        _builder.newLine();
        _builder.append("import javax.net.ssl.TrustManagerFactory;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("import org.apache.log4j.Logger;");
        _builder.newLine();
        _builder.append("import org.eclipse.paho.client.mqttv3.IMqttActionListener;");
        _builder.newLine();
        _builder.append("import org.eclipse.paho.client.mqttv3.IMqttToken;");
        _builder.newLine();
        _builder.append("import org.eclipse.paho.client.mqttv3.MqttClient;");
        _builder.newLine();
        _builder.append("import org.eclipse.paho.client.mqttv3.MqttConnectOptions;");
        _builder.newLine();
        _builder.append("import org.eclipse.paho.client.mqttv3.MqttException;");
        _builder.newLine();
        _builder.append("import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* MQTTv3 Client based on Eclipse Paho ");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("public class HonoMqttClient {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private static final Logger logger = Logger.getLogger(HonoMqttClient.class);");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private static final URL CERTIFICATE_LOCATION = HonoMqttClient.class.getResource(\"/certificate/hono.crt\");");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private String mqttHostUrl;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private String clientId;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private MqttClient mqttClient = null;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private MqttConnectOptions connOpts = null;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public HonoMqttClient(String mqttHostUrl, String clientId, String authId, String password) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.mqttHostUrl = Objects.requireNonNull(mqttHostUrl);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.clientId = Objects.requireNonNull(clientId);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("try {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("logger.info(String.format(\"Creating Hub Client for [%s] with Client Id [%s]\", mqttHostUrl, clientId));");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("mqttClient = new MqttClient(mqttHostUrl, clientId, new MemoryPersistence());");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("connOpts = new MqttConnectOptions();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("connOpts.setUserName(authId);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("connOpts.setPassword(password.toCharArray());");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("connOpts.setSocketFactory(buildSslSocketFactory(CERTIFICATE_LOCATION));");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("} catch (MqttException e) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("logger.error(\"Exception connecting to Hono\", e);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("throw new RuntimeException(e);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void connect() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("try {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("logger.info(\"Connecting to Hono.\");");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("IMqttToken token = mqttClient.connectWithResult(connOpts);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("token.setActionCallback(new IMqttActionListener() {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("public void onFailure(IMqttToken arg0, Throwable arg1) {");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("logger.error(\"Failed to connect to Hono [\" + mqttHostUrl + \", \" + clientId + \"]\", arg1);");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("public void onSuccess(IMqttToken arg0) {");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("logger.info(\"Connected to Hono [\" + mqttHostUrl + \", \" + clientId + \"]\");");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("});");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("logger.info(\"Hono Client CONNECTED.\");");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("} catch (MqttException e) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("throw new RuntimeException(e);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void send(String topic, String message) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (mqttClient != null) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if (mqttClient.isConnected()) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("try {");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("logger.info(String.format(\"Sending topic [%s] message [%s]\", topic, message));");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("mqttClient.publish(topic, message.getBytes(), 0, false);");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("logger.info(String.format(\"Send done.\"));");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("} catch (MqttException e) {");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("logger.error(\"MQTT Client has error in sending message.\", e);");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("logger.error(\"Mqtt Client is not connected.\");");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("throw new RuntimeException(\"MQTT Client is not connected.\");");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("logger.error(\"Mqtt Client is not initialized.\");");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("throw new RuntimeException(\"MQTT Client is not initialized.\");");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public boolean isConnected() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return mqttClient != null && mqttClient.isConnected();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private static SSLSocketFactory buildSslSocketFactory(URL certificateUrl) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("try {");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("CertificateFactory certFactory = CertificateFactory.getInstance(\"X.509\");");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("InputStream certificateInputstream = new BufferedInputStream(Objects.requireNonNull(certificateUrl).openStream());");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("Certificate certificate;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("try {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("certificate = certFactory.generateCertificate(certificateInputstream);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("} finally {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("certificateInputstream.close();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("// Create a KeyStore containing our trusted CAs");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("keyStore.load(null, null);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("keyStore.setCertificateEntry(\"ca\", certificate);");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("// Create a TrustManager that trusts the CAs in our KeyStore");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("tmf.init(keyStore);");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("// Create an SSLContext that uses our TrustManager");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("SSLContext context = SSLContext.getInstance(\"TLS\");");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("context.init(null, tmf.getTrustManagers(), null);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return context.getSocketFactory();");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("} catch (NoSuchAlgorithmException | KeyStoreException | KeyManagementException | CertificateException | IOException e) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("logger.error(\"Error building ssl socket factory\", e);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return null;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        return _builder.toString();
    }
}

