/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.hono.arduino;

import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.vorto.core.api.model.datatype.DictionaryPropertyType;
import org.eclipse.vorto.core.api.model.datatype.Entity;
import org.eclipse.vorto.core.api.model.datatype.Enum;
import org.eclipse.vorto.core.api.model.datatype.EnumLiteral;
import org.eclipse.vorto.core.api.model.datatype.ObjectPropertyType;
import org.eclipse.vorto.core.api.model.datatype.PrimitivePropertyType;
import org.eclipse.vorto.core.api.model.datatype.PrimitiveType;
import org.eclipse.vorto.core.api.model.datatype.Property;
import org.eclipse.vorto.core.api.model.datatype.PropertyType;
import org.eclipse.vorto.core.api.model.functionblock.FunctionBlock;
import org.eclipse.vorto.core.api.model.model.Model;
import org.eclipse.vorto.plugin.generator.utils.IFileTemplate;
import org.eclipse.vorto.plugin.utils.Utils;

public abstract class ArduinoTemplate<T extends Model>
implements IFileTemplate<T> {
    public String rootPath;

    public String type(PropertyType type) {
        if (type instanceof PrimitivePropertyType) {
            return this.toCppPrimitive(((PrimitivePropertyType)type).getType());
        }
        if (type instanceof DictionaryPropertyType) {
            return "map()";
        }
        String _replace = ((ObjectPropertyType)type).getType().getNamespace().replace(".", "_");
        String _plus = _replace + "::";
        String _name = ((ObjectPropertyType)type).getType().getName();
        return _plus + _name;
    }

    public String toCppPrimitive(PrimitiveType primitiveType) {
        if (primitiveType != null) {
            switch (primitiveType) {
                case DOUBLE: {
                    return "double";
                }
                case FLOAT: {
                    return "float";
                }
                case INT: {
                    return "uint32_t";
                }
                case LONG: {
                    return "uint64_t";
                }
                case BOOLEAN: {
                    return "bool";
                }
                case BASE64_BINARY: {
                    return "char[]";
                }
                case STRING: {
                    return "String";
                }
            }
            return "String";
        }
        return "String";
    }

    public boolean isNumericType(PropertyType type) {
        if (type instanceof PrimitivePropertyType) {
            PrimitiveType _type = ((PrimitivePropertyType)type).getType();
            if (_type != null) {
                switch (_type) {
                    case DOUBLE: {
                        return true;
                    }
                    case FLOAT: {
                        return true;
                    }
                    case INT: {
                        return true;
                    }
                    case LONG: {
                        return true;
                    }
                    case BOOLEAN: {
                        return true;
                    }
                    case BASE64_BINARY: {
                        return false;
                    }
                    case STRING: {
                        return false;
                    }
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public boolean isAlphabetical(PropertyType type) {
        if (type instanceof PrimitivePropertyType) {
            PrimitiveType _type = ((PrimitivePropertyType)type).getType();
            if (_type != null) {
                switch (_type) {
                    case STRING: {
                        return true;
                    }
                    case BASE64_BINARY: {
                        return true;
                    }
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public boolean isEnum(FunctionBlock fb, PropertyType type) {
        boolean _xifexpression = false;
        if (type instanceof ObjectPropertyType && !Utils.getReferencedEnums((FunctionBlock)fb).isEmpty()) {
            EList _referencedEnums = Utils.getReferencedEnums((FunctionBlock)fb);
            Iterator iterator = _referencedEnums.iterator();
            if (iterator.hasNext()) {
                Enum enum_ = (Enum)iterator.next();
                return enum_.getDisplayname().equals(((ObjectPropertyType)type).getType().getName()) && enum_.getNamespace().equals(((ObjectPropertyType)type).getType().getNamespace());
            }
        } else {
            return false;
        }
        return _xifexpression;
    }

    public String getFirstValueEnum(FunctionBlock fb, PropertyType type) {
        EList _referencedEnums = Utils.getReferencedEnums((FunctionBlock)fb);
        for (Enum enum_ : _referencedEnums) {
            if (!enum_.getDisplayname().equals(((ObjectPropertyType)type).getType().getName()) || !enum_.getNamespace().equals(((ObjectPropertyType)type).getType().getNamespace())) continue;
            return ((EnumLiteral)enum_.getEnums().get(0)).getName();
        }
        return "";
    }

    public boolean isEntity(FunctionBlock fb, PropertyType type) {
        boolean _xifexpression = false;
        if (type instanceof ObjectPropertyType && !Utils.getReferencedEntities((FunctionBlock)fb).isEmpty()) {
            EList _referencedEntities = Utils.getReferencedEntities((FunctionBlock)fb);
            Iterator iterator = _referencedEntities.iterator();
            if (iterator.hasNext()) {
                Entity entity = (Entity)iterator.next();
                return entity.getDisplayname().equals(((ObjectPropertyType)type).getType().getName()) && entity.getNamespace().equals(((ObjectPropertyType)type).getType().getNamespace());
            }
        } else {
            return false;
        }
        return _xifexpression;
    }

    public EList<Property> getEntity(FunctionBlock fb, PropertyType type) {
        EList _referencedEntities = Utils.getReferencedEntities((FunctionBlock)fb);
        for (Entity entity : _referencedEntities) {
            if (!entity.getDisplayname().equals(((ObjectPropertyType)type).getType().getName()) || !entity.getNamespace().equals(((ObjectPropertyType)type).getType().getNamespace())) continue;
            return entity.getProperties();
        }
        return null;
    }
}

