/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.hono.arduino;

import org.eclipse.emf.common.util.EList;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.hono.arduino.ArduinoTemplate;
import org.eclipse.vorto.core.api.model.datatype.Property;
import org.eclipse.vorto.core.api.model.functionblock.Configuration;
import org.eclipse.vorto.core.api.model.functionblock.Status;
import org.eclipse.vorto.core.api.model.informationmodel.FunctionblockProperty;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class ArduinoSketchTemplate
extends ArduinoTemplate<InformationModel> {
    public String getFileName(InformationModel model) {
        String _name = model.getName();
        return _name + "App.ino";
    }

    public String getPath(InformationModel model) {
        String _name = model.getName();
        return _name + "App";
    }

    public String getContent(InformationModel model, InvocationContext context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("// Generated by Vorto from ");
        String _namespace = model.getNamespace();
        _builder.append(_namespace);
        _builder.append(".");
        String _name = model.getName();
        _builder.append(_name);
        _builder.append(":");
        String _version = model.getVersion();
        _builder.append(_version);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#define USE_SECURE_CONNECTION 1");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#include <PubSubClient.h>");
        _builder.newLine();
        _builder.append("#include <ESP8266WiFi.h>");
        _builder.newLine();
        _builder.append("#if (USE_SECURE_CONNECTION == 1)");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("#include <WiFiClientSecure.h>");
        _builder.newLine();
        _builder.append("#endif");
        _builder.newLine();
        EList _properties = model.getProperties();
        for (FunctionblockProperty fb : _properties) {
            _builder.append("#include \"src/model/functionblock/");
            String _name_1 = fb.getType().getName();
            _builder.append(_name_1);
            _builder.append(".h\"");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("#include \"src/model/infomodel/");
        String _name_2 = model.getName();
        _builder.append(_name_2);
        _builder.append(".h\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/**************************************************************************/");
        _builder.newLine();
        _builder.append("/* Configuration section, adjust to your settings                         */");
        _builder.newLine();
        _builder.append("/**************************************************************************/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#define tenantId \"");
        String _orDefault = context.getConfigurationProperties().getOrDefault("tenantId", "ADD TENANT ID HERE");
        _builder.append(_orDefault);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/* MQTT broker endpoint */");
        _builder.newLine();
        _builder.append("const char* hub_adapter_host = \"");
        String _orDefault_1 = context.getConfigurationProperties().getOrDefault("hub_adapter_host", "mqtt.bosch-iot-hub.com");
        _builder.append(_orDefault_1);
        _builder.append("\";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#if (USE_SECURE_CONNECTION == 1)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/* SHA-1 fingerprint of the server certificate of the MQTT broker, UPPERCASE and spacing */");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("const char* mqttServerFingerprint = \"<XX XX XX XX XX XX XX XX XX XX XX XX XX XX XX XX XX XX XX XX>\";");
        _builder.newLine();
        _builder.append("#endif");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/* Define the period of data transmission in ms */");
        _builder.newLine();
        _builder.append("#define MQTT_DATA_PERIOD 10000");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/* Define the buffer size for payload strings */");
        _builder.newLine();
        _builder.append("#define MQTT_MAX_SIZE  50");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/* Device Configuration */");
        _builder.newLine();
        _builder.append("String deviceId = \"");
        String _orDefault_2 = context.getConfigurationProperties().getOrDefault("deviceId", "ADD DEVICE ID HERE");
        _builder.append(_orDefault_2);
        _builder.append("\";");
        _builder.newLineIfNotEmpty();
        _builder.append("String authId = \"ADD AUTH ID HERE\";");
        _builder.newLine();
        _builder.append("const char* device_password = \"");
        String _orDefault_3 = context.getConfigurationProperties().getOrDefault("device_password", "ADD DEVICE PASSWORD HERE");
        _builder.append(_orDefault_3);
        _builder.append("\";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/* Payload Configuration*/");
        _builder.newLine();
        _builder.append("String ditto_topic = \"");
        String _orDefault_4 = context.getConfigurationProperties().getOrDefault("ditto_topic", "ADD DITTO TOPIC HERE, e.g. com.mycompany/4711");
        _builder.append(_orDefault_4);
        _builder.append("\";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/* WiFi Configuration */");
        _builder.newLine();
        _builder.append("const char* ssid = \"<ENTER YOUR WIFI SSID>\";");
        _builder.newLine();
        _builder.append("const char* password = \"<ENTER YOUR WIFI PASSWORD>\";");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/* BEGIN SAMPLE CODE */");
        _builder.newLine();
        _builder.append("/* dummy numeric */");
        _builder.newLine();
        _builder.append("long dummy_value = 0;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/* Sample text value */");
        _builder.newLine();
        _builder.append("char msg[MQTT_MAX_SIZE];");
        _builder.newLine();
        _builder.append("/* END SAMPLE CODE */");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**************************************************************************/");
        _builder.newLine();
        _builder.append("/* Implementation                                                         */");
        _builder.newLine();
        _builder.append("/**************************************************************************/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/* Port on which the MQTT broker is listening */");
        _builder.newLine();
        _builder.append("#if (USE_SECURE_CONNECTION == 1)");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("#define MQTT_SERVER_PORT 8883");
        _builder.newLine();
        _builder.append("#else");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("#define MQTT_SERVER_PORT 1883");
        _builder.newLine();
        _builder.append("#endif");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/* Topic on which the telemetry data is published */");
        _builder.newLine();
        _builder.append("String telemetryTopic = String(\"telemetry/\") + String(tenantId) + String(\"/\");");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/* This variables stores the client ID in the MQTT protocol */");
        _builder.newLine();
        _builder.append("String clientId;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/* Timestamp of previous data transmission */");
        _builder.newLine();
        _builder.append("long lastMqttMsg;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/* Setup WiFi mqttClient and MQTT mqttClient */");
        _builder.newLine();
        _builder.append("#if (USE_SECURE_CONNECTION == 1)");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("WiFiClientSecure wifiClient;");
        _builder.newLine();
        _builder.append("#else");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("WiFiClient wifiClient;");
        _builder.newLine();
        _builder.append("#endif");
        _builder.newLine();
        _builder.append("PubSubClient mqttClient(wifiClient);");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/* The information model object */");
        _builder.newLine();
        String _replace = model.getNamespace().replace(".", "_");
        _builder.append(_replace);
        _builder.append("::");
        String _name_3 = model.getName();
        _builder.append(_name_3);
        _builder.append(" infoModel;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/**************************************************************************/");
        _builder.newLine();
        _builder.append("/* Function to connect to the WiFi network                                */");
        _builder.newLine();
        _builder.append("/**************************************************************************/");
        _builder.newLine();
        _builder.append("void setup_wifi() {");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("delay(10);");
        _builder.newLine();
        _builder.append("  ");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("/* We start by connecting to a WiFi network */");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("Serial.print(\"Connecting to WiFi with SSID: \");");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("Serial.println(ssid);");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("WiFi.begin(ssid, password);");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("/* Wait for succesful connection, hang if there is none? */");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("while (WiFi.status() != WL_CONNECTED) {");
        _builder.newLine();
        _builder.append("    \t");
        _builder.append("Serial.print(\".\");");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("delay(500);");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("randomSeed(micros());");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("Serial.println(\"\");");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("Serial.println(\"WiFi connected\");");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("Serial.print(\"IP address: \");");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("Serial.println(WiFi.localIP());");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("Serial.print(\"MAC address: \");");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("Serial.println(WiFi.macAddress());");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**************************************************************************/");
        _builder.newLine();
        _builder.append("/* Function called when data on a subscribed topic arrives                */");
        _builder.newLine();
        _builder.append("/**************************************************************************/");
        _builder.newLine();
        _builder.append("void mqttDataReceived(char* topic, byte* payload, unsigned int length) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("/* BEGIN SAMPLE CODE */");
        _builder.newLine();
        _builder.append("     \t\t ");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("if ((char)payload[0] == '1') {\t\t  \t    ");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("Serial.println(\"MQTT Data sucessfully received\"); ");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("} else {\t\t  \t    ");
        _builder.newLine();
        _builder.append("      \t");
        _builder.append("Serial.println(\"No MQTT Data reveived\");");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("    ");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("/* END SAMPE CODE */");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**************************************************************************/");
        _builder.newLine();
        _builder.append("/* Reconnect to MQTT broker in case the connection dropped                */");
        _builder.newLine();
        _builder.append("/**************************************************************************/");
        _builder.newLine();
        _builder.append("void reconnect() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("String username = String(authId) + \"@\" + String(tenantId);");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("/* Loop while not connected */");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("while (!mqttClient.connected()) {\t\t    ");
        _builder.newLine();
        _builder.newLine();
        _builder.append("        ");
        _builder.append("/* If connected to the MQTT broker... */");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("if (mqttClient.connect(clientId.c_str(),username.c_str(),device_password)) {");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("/* Attempt to Connect succesfull */\t\t            ");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("Serial.println(\"Successfully connected to MQTT Broker\");");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("/* SAMPLE CODE */");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("//String topic = telemetryTopic + \"/led\";");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("//mqttClient.subscribe(topic.c_str());\t\t            ");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("/* END SAMPLE CODE */");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("    \t    ");
        _builder.append("/* otherwise wait for 5 seconds before retrying */");
        _builder.newLine();
        _builder.append("    \t    ");
        _builder.append("Serial.println(\"Waiting for next attempt to connect to MQTT Broker\");");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("delay(5000);");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**************************************************************************/");
        _builder.newLine();
        _builder.append("/* Functions for publishing data using MQTT\t\t\t\t\t              */");
        _builder.newLine();
        _builder.append("/**************************************************************************/");
        _builder.newLine();
        _builder.newLine();
        EList _properties_1 = model.getProperties();
        for (FunctionblockProperty fb_1 : _properties_1) {
            _builder.append("boolean publish");
            String _firstUpper = StringExtensions.toFirstUpper((String)fb_1.getName());
            _builder.append(_firstUpper);
            _builder.append("() {\t\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("String mqttPayload = infoModel.");
            String _name_4 = fb_1.getName();
            _builder.append(_name_4, "\t\t");
            _builder.append(".serialize(ditto_topic ,deviceId, \"");
            String _name_5 = fb_1.getName();
            _builder.append(_name_5, "\t\t");
            _builder.append("\");");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("/* Debug output on console */");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("Serial.print(\"Publishing Payload for ");
            String _name_6 = fb_1.getName();
            _builder.append(_name_6, "\t\t");
            _builder.append(": \"); ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("Serial.print(mqttPayload);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("Serial.print(\" to topic: \"); ");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("Serial.println(telemetryTopic);");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("/* Publish all available ");
            String _name_7 = fb_1.getName();
            _builder.append(_name_7, "\t\t");
            _builder.append(" data to the MQTT broker */");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("if(!mqttClient.publish(telemetryTopic.c_str(), mqttPayload.c_str())) {\t\t \t    ");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("Serial.println(\"Publish ");
            String _name_8 = fb_1.getName();
            _builder.append(_name_8, "\t\t\t");
            _builder.append(" failed, if this happens repeatedly increase MQTT_MAX_PACKET_SIZE in PubSubClient.h\");\t\t \t    ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t");
            _builder.append("return false;");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("} else {\t\t \t    ");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("return true; \t\t  \t");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("}\t\t ");
            _builder.newLine();
            _builder.append("}       \t");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("/**************************************************************************/");
        _builder.newLine();
        _builder.append("/* Arduino Setup and Loop Functions\t\t\t\t\t\t\t              */");
        _builder.newLine();
        _builder.append("/**************************************************************************/");
        _builder.newLine();
        _builder.append("void setup() {\t\t    ");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("Serial.begin(115200);");
        _builder.newLine();
        _builder.append("    ");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("setup_wifi();");
        _builder.newLine();
        _builder.append("  ");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("/* Create a MQTT client ID */");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("clientId = deviceId;");
        _builder.newLine();
        _builder.append("    ");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("Serial.print(\"Device ID: \");");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("Serial.println(clientId);");
        _builder.newLine();
        _builder.append("    ");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("/* Add the device ID to the telemetry topic as the final element */");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("telemetryTopic += deviceId;");
        _builder.newLine();
        _builder.append("  ");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("/* Configure the MQTT client with the server and callback data */");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("mqttClient.setServer(hub_adapter_host, MQTT_SERVER_PORT);");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("mqttClient.setCallback(mqttDataReceived);");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("#if (USE_SECURE_CONNECTION == 1)");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("if (!wifiClient.connect(hub_adapter_host, MQTT_SERVER_PORT)) {");
        _builder.newLine();
        _builder.append("        \t");
        _builder.append("Serial.println(\"Secure connection failed, restart Device\");\t\t            ");
        _builder.newLine();
        _builder.append("\t        ");
        _builder.append("ESP.restart();");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("        \t");
        _builder.append("Serial.println(\"Successfully established secure connection to broker\");");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("if (!wifiClient.verify(mqttServerFingerprint, hub_adapter_host)) {");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("Serial.println(\"Verification failed, restart Device\");\t");
        _builder.newLine();
        _builder.append("\t        ");
        _builder.append("ESP.restart();");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("        \t");
        _builder.append("Serial.println(\"Successfully verified server certificate\");");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("#endif");
        _builder.newLine();
        _builder.append("    ");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("/*Test MQQT Client*/");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("mqttClient.publish(\"\",\"\");");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("void loop() {\t\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/* Check if connection to MQTT broker is still good */");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("if (!mqttClient.connected()) {");
        _builder.newLine();
        _builder.append("    \t");
        _builder.append("/* Reconnect if not */");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("reconnect();");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("    ");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("/* Event handling of the MQTT client */");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("mqttClient.loop();");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("/* Publish the telemetry data periodically */");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("long now = millis();");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("if (now - lastMqttMsg > MQTT_DATA_PERIOD) {");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("lastMqttMsg = now;");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("/* SAMPLE CODE */");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("dummy_value++;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("snprintf(msg, MQTT_MAX_SIZE - 1, \"hello world #%ld\", dummy_value);");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        EList _properties_2 = model.getProperties();
        for (FunctionblockProperty fb_2 : _properties_2) {
            Configuration _configuration;
            boolean _tripleNotEquals_1;
            boolean _tripleNotEquals;
            Status _status = fb_2.getType().getFunctionblock().getStatus();
            boolean bl = _tripleNotEquals = _status != null;
            if (_tripleNotEquals) {
                _builder.append("        ");
                _builder.append("//Status Properties");
                _builder.newLine();
                EList _properties_3 = fb_2.getType().getFunctionblock().getStatus().getProperties();
                for (Property status : _properties_3) {
                    boolean _isNumericType = this.isNumericType(status.getType());
                    if (_isNumericType) {
                        _builder.append("        ");
                        _builder.append("\t");
                        _builder.append("infoModel.");
                        String _name_9 = fb_2.getName();
                        _builder.append(_name_9, "        \t");
                        _builder.append(".set");
                        String _name_10 = status.getName();
                        _builder.append(_name_10, "        \t");
                        _builder.append("(dummy_value);");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    boolean _isAlphabetical = this.isAlphabetical(status.getType());
                    if (_isAlphabetical) {
                        _builder.append("        ");
                        _builder.append("\t");
                        _builder.append("infoModel.");
                        String _name_11 = fb_2.getName();
                        _builder.append(_name_11, "        \t");
                        _builder.append(".set");
                        String _name_12 = status.getName();
                        _builder.append(_name_12, "        \t");
                        _builder.append("(msg);");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    boolean _isEnum = this.isEnum(fb_2.getType().getFunctionblock(), status.getType());
                    if (_isEnum) {
                        _builder.append("        ");
                        _builder.append("\t");
                        _builder.append("infoModel.");
                        String _name_13 = fb_2.getName();
                        _builder.append(_name_13, "        \t");
                        _builder.append(".set");
                        String _name_14 = status.getName();
                        _builder.append(_name_14, "        \t");
                        _builder.append("(");
                        String _type = this.type(status.getType());
                        _builder.append(_type, "        \t");
                        _builder.append("::");
                        String _firstValueEnum = this.getFirstValueEnum(fb_2.getType().getFunctionblock(), status.getType());
                        _builder.append(_firstValueEnum, "        \t");
                        _builder.append(");");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    boolean _isEntity = this.isEntity(fb_2.getType().getFunctionblock(), status.getType());
                    if (!_isEntity) continue;
                    _builder.append("        ");
                    _builder.append("\t");
                    String _type_1 = this.type(status.getType());
                    _builder.append(_type_1, "        \t");
                    _builder.append(" ");
                    String _name_15 = status.getName();
                    _builder.append(_name_15, "        \t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    EList<Property> _entity = this.getEntity(fb_2.getType().getFunctionblock(), status.getType());
                    for (Property Entity2 : _entity) {
                        boolean _isNumericType_1 = this.isNumericType(Entity2.getType());
                        if (_isNumericType_1) {
                            _builder.append("        ");
                            _builder.append("\t");
                            String _name_16 = status.getName();
                            _builder.append(_name_16, "        \t");
                            _builder.append(".set");
                            String _name_17 = Entity2.getName();
                            _builder.append(_name_17, "        \t");
                            _builder.append("(dummy_value);");
                            _builder.newLineIfNotEmpty();
                            continue;
                        }
                        boolean _isAlphabetical_1 = this.isAlphabetical(Entity2.getType());
                        if (!_isAlphabetical_1) continue;
                        _builder.append("        ");
                        _builder.append("\t");
                        String _name_18 = status.getName();
                        _builder.append(_name_18, "        \t");
                        _builder.append(".set");
                        String _name_19 = Entity2.getName();
                        _builder.append(_name_19, "        \t");
                        _builder.append("(msg);");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append("        ");
                    _builder.append("\t");
                    _builder.append("infoModel.");
                    String _name_20 = fb_2.getName();
                    _builder.append(_name_20, "        \t");
                    _builder.append(".set");
                    String _name_21 = status.getName();
                    _builder.append(_name_21, "        \t");
                    _builder.append("(");
                    String _name_22 = status.getName();
                    _builder.append(_name_22, "        \t");
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                }
            }
            if (!(_tripleNotEquals_1 = (_configuration = fb_2.getType().getFunctionblock().getConfiguration()) != null)) continue;
            _builder.append("        ");
            _builder.append("//Configuration Properties");
            _builder.newLine();
            EList _properties_4 = fb_2.getType().getFunctionblock().getConfiguration().getProperties();
            for (Property configuration : _properties_4) {
                boolean _isNumericType_2 = this.isNumericType(configuration.getType());
                if (_isNumericType_2) {
                    _builder.append("        ");
                    _builder.append("\t");
                    _builder.append("infoModel.");
                    String _name_23 = fb_2.getName();
                    _builder.append(_name_23, "        \t");
                    _builder.append(".set");
                    String _name_24 = configuration.getName();
                    _builder.append(_name_24, "        \t");
                    _builder.append("(dummy_value);");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                boolean _isAlphabetical_2 = this.isAlphabetical(configuration.getType());
                if (_isAlphabetical_2) {
                    _builder.append("        ");
                    _builder.append("\t");
                    _builder.append("infoModel.");
                    String _name_25 = fb_2.getName();
                    _builder.append(_name_25, "        \t");
                    _builder.append(".set");
                    String _name_26 = configuration.getName();
                    _builder.append(_name_26, "        \t");
                    _builder.append("(msg);");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                boolean _isEnum_1 = this.isEnum(fb_2.getType().getFunctionblock(), configuration.getType());
                if (_isEnum_1) {
                    _builder.append("        ");
                    _builder.append("\t");
                    _builder.append("infoModel.");
                    String _name_27 = fb_2.getName();
                    _builder.append(_name_27, "        \t");
                    _builder.append(".set");
                    String _name_28 = configuration.getName();
                    _builder.append(_name_28, "        \t");
                    _builder.append("(");
                    String _type_2 = this.type(configuration.getType());
                    _builder.append(_type_2, "        \t");
                    _builder.append("::");
                    String _firstValueEnum_1 = this.getFirstValueEnum(fb_2.getType().getFunctionblock(), configuration.getType());
                    _builder.append(_firstValueEnum_1, "        \t");
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                boolean _isEntity_1 = this.isEntity(fb_2.getType().getFunctionblock(), configuration.getType());
                if (!_isEntity_1) continue;
                _builder.append("        ");
                _builder.append("\t");
                String _type_3 = this.type(configuration.getType());
                _builder.append(_type_3, "        \t");
                _builder.append(" ");
                String _name_29 = configuration.getName();
                _builder.append(_name_29, "        \t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                EList<Property> _entity_1 = this.getEntity(fb_2.getType().getFunctionblock(), configuration.getType());
                for (Property Entity_1 : _entity_1) {
                    boolean _isNumericType_3 = this.isNumericType(Entity_1.getType());
                    if (_isNumericType_3) {
                        _builder.append("        ");
                        _builder.append("\t");
                        String _name_30 = configuration.getName();
                        _builder.append(_name_30, "        \t");
                        _builder.append(".set");
                        String _name_31 = Entity_1.getName();
                        _builder.append(_name_31, "        \t");
                        _builder.append("(dummy_value);");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    boolean _isAlphabetical_3 = this.isAlphabetical(Entity_1.getType());
                    if (!_isAlphabetical_3) continue;
                    _builder.append("        ");
                    _builder.append("\t");
                    String _name_32 = configuration.getName();
                    _builder.append(_name_32, "        \t");
                    _builder.append(".set");
                    String _name_33 = Entity_1.getName();
                    _builder.append(_name_33, "        \t");
                    _builder.append("(msg);");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("        ");
                _builder.append("\t");
                _builder.append("infoModel.");
                String _name_34 = fb_2.getName();
                _builder.append(_name_34, "        \t");
                _builder.append(".set");
                String _name_35 = configuration.getName();
                _builder.append(_name_35, "        \t");
                _builder.append("(");
                String _name_36 = configuration.getName();
                _builder.append(_name_36, "        \t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("        ");
        _builder.newLine();
        EList _properties_5 = model.getProperties();
        for (FunctionblockProperty fb_3 : _properties_5) {
            _builder.append("        ");
            _builder.append("publish");
            String _firstUpper_1 = StringExtensions.toFirstUpper((String)fb_3.getName());
            _builder.append(_firstUpper_1, "        ");
            _builder.append("();");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("/* END OF SAMPLE CODE */");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder.toString();
    }
}

