/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.hono.arduino;

import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.vorto.codegen.api.IFileTemplate;
import org.eclipse.vorto.codegen.utils.Utils;
import org.eclipse.vorto.core.api.model.datatype.DictionaryPropertyType;
import org.eclipse.vorto.core.api.model.datatype.Entity;
import org.eclipse.vorto.core.api.model.datatype.Enum;
import org.eclipse.vorto.core.api.model.datatype.EnumLiteral;
import org.eclipse.vorto.core.api.model.datatype.ObjectPropertyType;
import org.eclipse.vorto.core.api.model.datatype.PrimitivePropertyType;
import org.eclipse.vorto.core.api.model.datatype.PrimitiveType;
import org.eclipse.vorto.core.api.model.datatype.Property;
import org.eclipse.vorto.core.api.model.datatype.PropertyType;
import org.eclipse.vorto.core.api.model.datatype.Type;
import org.eclipse.vorto.core.api.model.functionblock.FunctionBlock;
import org.eclipse.vorto.core.api.model.model.Model;

public abstract class ArduinoTemplate<T extends Model>
implements IFileTemplate<T> {
    public String rootPath;

    public String type(PropertyType type) {
        if (type instanceof PrimitivePropertyType) {
            PrimitiveType _type = ((PrimitivePropertyType)type).getType();
            return this.toCppPrimitive(_type);
        }
        if (type instanceof DictionaryPropertyType) {
            PropertyType _keyType = ((DictionaryPropertyType)type).getKeyType();
            String _type_1 = this.type(_keyType);
            String _plus = "map<" + _type_1;
            String _plus_1 = _plus + ",";
            PropertyType _valueType = ((DictionaryPropertyType)type).getValueType();
            String _type_2 = this.type(_valueType);
            String _plus_2 = _plus_1 + _type_2;
            return _plus_2 + ">";
        }
        Type _type_3 = ((ObjectPropertyType)type).getType();
        String _namespace = _type_3.getNamespace();
        String _replace = _namespace.replace(".", "_");
        String _plus_3 = _replace + "::";
        Type _type_4 = ((ObjectPropertyType)type).getType();
        String _name = _type_4.getName();
        return _plus_3 + _name;
    }

    public String toCppPrimitive(PrimitiveType primitiveType) {
        if (primitiveType != null) {
            switch (primitiveType) {
                case DOUBLE: {
                    return "double";
                }
                case FLOAT: {
                    return "float";
                }
                case INT: {
                    return "uint32_t";
                }
                case LONG: {
                    return "uint64_t";
                }
                case BOOLEAN: {
                    return "bool";
                }
                case BASE64_BINARY: {
                    return "char[]";
                }
                case STRING: {
                    return "String";
                }
            }
            return "String";
        }
        return "String";
    }

    public boolean isNumericType(PropertyType type) {
        if (type instanceof PrimitivePropertyType) {
            PrimitiveType _type = ((PrimitivePropertyType)type).getType();
            if (_type != null) {
                switch (_type) {
                    case DOUBLE: {
                        return true;
                    }
                    case FLOAT: {
                        return true;
                    }
                    case INT: {
                        return true;
                    }
                    case LONG: {
                        return true;
                    }
                    case BOOLEAN: {
                        return true;
                    }
                    case BASE64_BINARY: {
                        return false;
                    }
                    case STRING: {
                        return false;
                    }
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public boolean isAlphabetical(PropertyType type) {
        if (type instanceof PrimitivePropertyType) {
            PrimitiveType _type = ((PrimitivePropertyType)type).getType();
            if (_type != null) {
                switch (_type) {
                    case STRING: {
                        return true;
                    }
                    case BASE64_BINARY: {
                        return true;
                    }
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public boolean isEnum(FunctionBlock fb, PropertyType type) {
        EList _referencedEnums;
        boolean _isEmpty;
        boolean _not;
        boolean _xifexpression = false;
        boolean _and = false;
        _and = !(type instanceof ObjectPropertyType) ? false : (_not = !(_isEmpty = (_referencedEnums = Utils.getReferencedEnums((FunctionBlock)fb)).isEmpty()));
        if (_and) {
            EList _referencedEnums_1 = Utils.getReferencedEnums((FunctionBlock)fb);
            Iterator iterator = _referencedEnums_1.iterator();
            if (iterator.hasNext()) {
                Type _type;
                String _name;
                Enum enum_ = (Enum)iterator.next();
                boolean _and_1 = false;
                String _displayname = enum_.getDisplayname();
                boolean _equals = _displayname.equals(_name = (_type = ((ObjectPropertyType)type).getType()).getName());
                if (!_equals) {
                    _and_1 = false;
                } else {
                    boolean _equals_1;
                    String _namespace = enum_.getNamespace();
                    Type _type_1 = ((ObjectPropertyType)type).getType();
                    String _namespace_1 = _type_1.getNamespace();
                    _and_1 = _equals_1 = _namespace.equals(_namespace_1);
                }
                return _and_1;
            }
        } else {
            return false;
        }
        return _xifexpression;
    }

    public String getFirstValueEnum(FunctionBlock fb, PropertyType type) {
        EList _referencedEnums = Utils.getReferencedEnums((FunctionBlock)fb);
        for (Enum enum_ : _referencedEnums) {
            Type _type;
            String _name;
            boolean _and = false;
            String _displayname = enum_.getDisplayname();
            boolean _equals = _displayname.equals(_name = (_type = ((ObjectPropertyType)type).getType()).getName());
            if (!_equals) {
                _and = false;
            } else {
                boolean _equals_1;
                String _namespace = enum_.getNamespace();
                Type _type_1 = ((ObjectPropertyType)type).getType();
                String _namespace_1 = _type_1.getNamespace();
                _and = _equals_1 = _namespace.equals(_namespace_1);
            }
            if (!_and) continue;
            EList _enums = enum_.getEnums();
            EnumLiteral _get = (EnumLiteral)_enums.get(0);
            return _get.getName();
        }
        return "";
    }

    public boolean isEntity(FunctionBlock fb, PropertyType type) {
        EList _referencedEntities;
        boolean _isEmpty;
        boolean _not;
        boolean _xifexpression = false;
        boolean _and = false;
        _and = !(type instanceof ObjectPropertyType) ? false : (_not = !(_isEmpty = (_referencedEntities = Utils.getReferencedEntities((FunctionBlock)fb)).isEmpty()));
        if (_and) {
            EList _referencedEntities_1 = Utils.getReferencedEntities((FunctionBlock)fb);
            Iterator iterator = _referencedEntities_1.iterator();
            if (iterator.hasNext()) {
                Type _type;
                String _name;
                Entity entity = (Entity)iterator.next();
                boolean _and_1 = false;
                String _displayname = entity.getDisplayname();
                boolean _equals = _displayname.equals(_name = (_type = ((ObjectPropertyType)type).getType()).getName());
                if (!_equals) {
                    _and_1 = false;
                } else {
                    boolean _equals_1;
                    String _namespace = entity.getNamespace();
                    Type _type_1 = ((ObjectPropertyType)type).getType();
                    String _namespace_1 = _type_1.getNamespace();
                    _and_1 = _equals_1 = _namespace.equals(_namespace_1);
                }
                return _and_1;
            }
        } else {
            return false;
        }
        return _xifexpression;
    }

    public EList<Property> getEntity(FunctionBlock fb, PropertyType type) {
        EList _referencedEntities = Utils.getReferencedEntities((FunctionBlock)fb);
        for (Entity entity : _referencedEntities) {
            Type _type;
            String _name;
            boolean _and = false;
            String _displayname = entity.getDisplayname();
            boolean _equals = _displayname.equals(_name = (_type = ((ObjectPropertyType)type).getType()).getName());
            if (!_equals) {
                _and = false;
            } else {
                boolean _equals_1;
                String _namespace = entity.getNamespace();
                Type _type_1 = ((ObjectPropertyType)type).getType();
                String _namespace_1 = _type_1.getNamespace();
                _and = _equals_1 = _namespace.equals(_namespace_1);
            }
            if (!_and) continue;
            return entity.getProperties();
        }
        return null;
    }
}

