/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.hono.arduino;

import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.hono.arduino.ArduinoTemplate;
import org.eclipse.vorto.core.api.model.datatype.Property;
import org.eclipse.vorto.core.api.model.datatype.PropertyType;
import org.eclipse.vorto.core.api.model.functionblock.Configuration;
import org.eclipse.vorto.core.api.model.functionblock.FunctionBlock;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.functionblock.Status;
import org.eclipse.vorto.core.api.model.informationmodel.FunctionblockProperty;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class ArduinoSketchTemplate
extends ArduinoTemplate<InformationModel> {
    public String getFileName(InformationModel model) {
        String _name = model.getName();
        return _name + "App.ino";
    }

    public String getPath(InformationModel model) {
        String _name = model.getName();
        return _name + "App";
    }

    public String getContent(InformationModel model, InvocationContext context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"// Generated by Vorto from ");
        String _namespace = model.getNamespace();
        _builder.append((Object)_namespace, "");
        _builder.append((Object)".");
        String _name = model.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)":");
        String _version = model.getVersion();
        _builder.append((Object)_version, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"#define USE_SECURE_CONNECTION 1");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"#include <PubSubClient.h>");
        _builder.newLine();
        _builder.append((Object)"#include <ESP8266WiFi.h>");
        _builder.newLine();
        _builder.append((Object)"#if (USE_SECURE_CONNECTION == 1)");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"#include <WiFiClientSecure.h>");
        _builder.newLine();
        _builder.append((Object)"#endif");
        _builder.newLine();
        EList _properties = model.getProperties();
        for (FunctionblockProperty fb : _properties) {
            _builder.append((Object)"#include \"src/model/functionblock/");
            FunctionblockModel _type = fb.getType();
            String _name_1 = _type.getName();
            _builder.append((Object)_name_1, "");
            _builder.append((Object)".h\"");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"#include \"src/model/infomodel/");
        String _name_2 = model.getName();
        _builder.append((Object)_name_2, "");
        _builder.append((Object)".h\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"/**************************************************************************/");
        _builder.newLine();
        _builder.append((Object)"/* Configuration section, adjust to your settings                         */");
        _builder.newLine();
        _builder.append((Object)"/**************************************************************************/");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/* Your tenant in Eclipse Hono / Bosch IoT Hub */");
        _builder.newLine();
        _builder.append((Object)"#define hono_tenant \"");
        Map _configurationProperties = context.getConfigurationProperties();
        String _orDefault = _configurationProperties.getOrDefault("hono_tenant", "DEFAULT_TENANT");
        _builder.append((Object)_orDefault, "");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"/* Define the period of data transmission in ms */");
        _builder.newLine();
        _builder.append((Object)"#define MQTT_DATA_PERIOD 10000");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/* Define the buffer size for payload strings */");
        _builder.newLine();
        _builder.append((Object)"#define MQTT_MAX_SIZE  50");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/* Device Configuration */");
        _builder.newLine();
        _builder.append((Object)"String hono_deviceId = \"");
        Map _configurationProperties_1 = context.getConfigurationProperties();
        String _orDefault_1 = _configurationProperties_1.getOrDefault("hono_deviceId", "nodemcu-");
        _builder.append((Object)_orDefault_1, "");
        _builder.append((Object)"\";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"String ditto_namespace = \"");
        Map _configurationProperties_2 = context.getConfigurationProperties();
        String _orDefault_2 = _configurationProperties_2.getOrDefault("ditto_namespace", "com.mycompany");
        _builder.append((Object)_orDefault_2, "");
        _builder.append((Object)"\";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"/* MQTT broker endpoint */");
        _builder.newLine();
        _builder.append((Object)"const char* hono_endpoint = \"");
        Map _configurationProperties_3 = context.getConfigurationProperties();
        String _orDefault_3 = _configurationProperties_3.getOrDefault("hono_endpoint", "<ENTER YOUR MQTT BROKER DNS NAME>");
        _builder.append((Object)_orDefault_3, "");
        _builder.append((Object)"\";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"const char* hono_password = \"");
        Map _configurationProperties_4 = context.getConfigurationProperties();
        String _orDefault_4 = _configurationProperties_4.getOrDefault("hono_password", "<ENTER THE DEVICE PASSWORD HERE>");
        _builder.append((Object)_orDefault_4, "");
        _builder.append((Object)"\";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"String hono_authId;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"#if (USE_SECURE_CONNECTION == 1)");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"/* SHA-1 fingerprint of the server certificate of the MQTT broker, UPPERCASE and spacing */");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"const char* mqttServerFingerprint = \"<xx xx xx xx xx xx xx xx xx xx xx xx xx xx xx xx xx xx xx xx>\";");
        _builder.newLine();
        _builder.append((Object)"#endif");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/* WiFi Configuration */");
        _builder.newLine();
        _builder.append((Object)"const char* ssid = \"<ENTER YOUR WIFI SSID>\";");
        _builder.newLine();
        _builder.append((Object)"const char* password = \"<ENTER YOUR WIFI PASSWORD>\";");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/* BEGIN SAMPLE CODE */");
        _builder.newLine();
        _builder.append((Object)"/* Sample numeric */");
        _builder.newLine();
        _builder.append((Object)"long value = 0;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/* Sample text value */");
        _builder.newLine();
        _builder.append((Object)"char msg[MQTT_MAX_SIZE];");
        _builder.newLine();
        _builder.append((Object)"/* END SAMPLE CODE */");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/**************************************************************************/");
        _builder.newLine();
        _builder.append((Object)"/* Implementation                                                         */");
        _builder.newLine();
        _builder.append((Object)"/**************************************************************************/");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/* Port on which the MQTT broker is listening */");
        _builder.newLine();
        _builder.append((Object)"#if (USE_SECURE_CONNECTION == 1)");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"#define MQTT_SERVER_PORT 8883");
        _builder.newLine();
        _builder.append((Object)"#else");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"#define MQTT_SERVER_PORT 1883");
        _builder.newLine();
        _builder.append((Object)"#endif");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/* Topic on which the telemetry data is published */");
        _builder.newLine();
        _builder.append((Object)"String telemetryTopic = String(\"telemetry/\") + String(hono_tenant) + String(\"/\");");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/* This variables stores the client ID in the MQTT protocol */");
        _builder.newLine();
        _builder.append((Object)"String hono_clientId;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/* Timestamp of previous data transmission */");
        _builder.newLine();
        _builder.append((Object)"long lastMqttMsg;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/* Setup WiFi mqttClient and MQTT mqttClient */");
        _builder.newLine();
        _builder.append((Object)"#if (USE_SECURE_CONNECTION == 1)");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"WiFiClientSecure wifiClient;");
        _builder.newLine();
        _builder.append((Object)"#else");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"WiFiClient wifiClient;");
        _builder.newLine();
        _builder.append((Object)"#endif");
        _builder.newLine();
        _builder.append((Object)"PubSubClient mqttClient(wifiClient);");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/* The information model object */");
        _builder.newLine();
        String _namespace_1 = model.getNamespace();
        String _replace = _namespace_1.replace(".", "_");
        _builder.append((Object)_replace, "");
        _builder.append((Object)"::");
        String _name_3 = model.getName();
        _builder.append((Object)_name_3, "");
        _builder.append((Object)" infoModel;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"/**************************************************************************/");
        _builder.newLine();
        _builder.append((Object)"/* Function to connect to the WiFi network                                */");
        _builder.newLine();
        _builder.append((Object)"/**************************************************************************/");
        _builder.newLine();
        _builder.append((Object)"void setup_wifi() {");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"delay(10);");
        _builder.newLine();
        _builder.append((Object)"  ");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"/* We start by connecting to a WiFi network */");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"WiFi.begin(ssid, password);");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"/* Wait for succesful connection, hang if there is none? */");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"while (WiFi.status() != WL_CONNECTED) {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"delay(500);");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"randomSeed(micros());");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"Serial.println(\"WiFi connected\");");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"Serial.print(\"IP address: \");");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"Serial.println(WiFi.localIP());");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"Serial.print(\"MAC address: \");");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"Serial.println(WiFi.macAddress());");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/**************************************************************************/");
        _builder.newLine();
        _builder.append((Object)"/* Function called when data on a subscribed topic arrives                */");
        _builder.newLine();
        _builder.append((Object)"/**************************************************************************/");
        _builder.newLine();
        _builder.append((Object)"void mqttDataReceived(char* topic, byte* payload, unsigned int length) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"/* BEGIN SAMPLE CODE */");
        _builder.newLine();
        _builder.append((Object)"     \t\t ");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"if ((char)payload[0] == '1') {\t\t  \t    ");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"Serial.println(\"MQTT Data sucessfully received\"); ");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"} else {\t\t  \t    ");
        _builder.newLine();
        _builder.append((Object)"      \t");
        _builder.append((Object)"Serial.println(\"No MQTT Data reveived\");");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"/* END SAMPE CODE */");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/**************************************************************************/");
        _builder.newLine();
        _builder.append((Object)"/* Reconnect to MQTT broker in case the connection dropped                */");
        _builder.newLine();
        _builder.append((Object)"/**************************************************************************/");
        _builder.newLine();
        _builder.append((Object)"void reconnect() {");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"/* Loop while not connected */");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"while (!mqttClient.connected()) {\t\t    ");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"/* If connected to the MQTT broker... */");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"if (mqttClient.connect(hono_clientId.c_str(),hono_authId.c_str(),hono_password)) {");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"/* Attempt to Connect succesfull */\t\t            ");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"Serial.println(\"Succesfully connected to MQTT Broker\");");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"/* SAMPLE CODE */");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"//String topic = telemetryTopic + \"/led\";");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"//mqttClient.subscribe(topic.c_str());\t\t            ");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"/* END SAMPLE CODE */");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"} else {");
        _builder.newLine();
        _builder.append((Object)"    \t    ");
        _builder.append((Object)"/* otherwise wait for 5 seconds before retrying */");
        _builder.newLine();
        _builder.append((Object)"    \t    ");
        _builder.append((Object)"Serial.println(\"Waiting for next attempt to connect to MQTT Broker\");");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"delay(5000);");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/**************************************************************************/");
        _builder.newLine();
        _builder.append((Object)"/* Funtions for publishing data using MQTT\t\t\t\t\t              */");
        _builder.newLine();
        _builder.append((Object)"/**************************************************************************/");
        _builder.newLine();
        _builder.newLine();
        EList _properties_1 = model.getProperties();
        for (FunctionblockProperty fb_1 : _properties_1) {
            _builder.append((Object)"boolean publish");
            String _name_4 = fb_1.getName();
            String _firstUpper = StringExtensions.toFirstUpper((String)_name_4);
            _builder.append((Object)_firstUpper, "");
            _builder.append((Object)"() {\t\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"String mqttPayload = infoModel.");
            String _name_5 = fb_1.getName();
            _builder.append((Object)_name_5, "\t\t");
            _builder.append((Object)".serialize(ditto_namespace ,hono_deviceId, \"");
            String _name_6 = fb_1.getName();
            _builder.append((Object)_name_6, "\t\t");
            _builder.append((Object)"\");");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"/* Debug output on console */");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"Serial.print(\"Publishing Payload for ");
            String _name_7 = fb_1.getName();
            _builder.append((Object)_name_7, "\t\t");
            _builder.append((Object)": \"); ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"Serial.print(mqttPayload);");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"Serial.print(\" to topic: \"); ");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"Serial.println(telemetryTopic);");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"/* Publish all available ");
            String _name_8 = fb_1.getName();
            _builder.append((Object)_name_8, "\t\t");
            _builder.append((Object)" data to the MQTT broker */");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"if(!mqttClient.publish(telemetryTopic.c_str(), mqttPayload.c_str())) {\t\t \t    ");
            _builder.newLine();
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"Serial.println(\"Publish ");
            String _name_9 = fb_1.getName();
            _builder.append((Object)_name_9, "\t\t\t");
            _builder.append((Object)" failed, if this happens repeatedly increase MQTT_MAX_PACKET_SIZE in PubSubClient.h\");\t\t \t    ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"return false;");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"} else {\t\t \t    ");
            _builder.newLine();
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"return true; \t\t  \t");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"}\t\t ");
            _builder.newLine();
            _builder.append((Object)"}       \t");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append((Object)"/**************************************************************************/");
        _builder.newLine();
        _builder.append((Object)"/* Arduino Setup and Loop Functions\t\t\t\t\t\t\t              */");
        _builder.newLine();
        _builder.append((Object)"/**************************************************************************/");
        _builder.newLine();
        _builder.append((Object)"void setup() {\t\t    ");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"Serial.begin(115200);");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"setup_wifi();");
        _builder.newLine();
        _builder.append((Object)"  ");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"/* Create a the MQTT client and the Hono authID*/");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"hono_clientId = hono_deviceId;");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"hono_authId = String(hono_clientId) + \"@\" + String(hono_tenant);");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"Serial.print(\"Device ID: \");");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"Serial.println(hono_clientId);");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"/* Add the client ID to the telemetry topic as the final element */");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"telemetryTopic += hono_clientId;");
        _builder.newLine();
        _builder.append((Object)"  ");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"/* Configure the MQTT client with the server and callback data */");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"mqttClient.setServer(hono_endpoint, MQTT_SERVER_PORT);");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"mqttClient.setCallback(mqttDataReceived);");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"#if (USE_SECURE_CONNECTION == 1)");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"if (!wifiClient.connect(hono_endpoint, MQTT_SERVER_PORT)) {");
        _builder.newLine();
        _builder.append((Object)"        \t");
        _builder.append((Object)"Serial.println(\"Secure connection failed, restart Device\");\t\t            ");
        _builder.newLine();
        _builder.append((Object)"\t        ");
        _builder.append((Object)"ESP.restart();");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"} else {");
        _builder.newLine();
        _builder.append((Object)"        \t");
        _builder.append((Object)"Serial.println(\"Successfully established secure connection to broker\");");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"if (!wifiClient.verify(mqttServerFingerprint, hono_endpoint)) {");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"Serial.println(\"Verification failed, restart Device\");\t");
        _builder.newLine();
        _builder.append((Object)"\t        ");
        _builder.append((Object)"ESP.restart();");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"} else {");
        _builder.newLine();
        _builder.append((Object)"        \t");
        _builder.append((Object)"Serial.println(\"Successfully verified server certificate\");");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"#endif");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"/*Test MQQT Client*/");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"mqttClient.publish(\"\",\"\");");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"void loop() {\t\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/* Check if connection to MQTT broker is still good */");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"if (!mqttClient.connected()) {");
        _builder.newLine();
        _builder.append((Object)"    \t");
        _builder.append((Object)"/* Reconnect if not */");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"reconnect();");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"/* Event handling of the MQTT client */");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"mqttClient.loop();");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"/* Publish the telemetry data periodically */");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"long now = millis();");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"if (now - lastMqttMsg > MQTT_DATA_PERIOD) {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"lastMqttMsg = now;");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"/* SAMPLE CODE */");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"value++;");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"snprintf(msg, MQTT_MAX_SIZE - 1, \"hello world #%ld\", value);");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.newLine();
        EList _properties_2 = model.getProperties();
        for (FunctionblockProperty fb_2 : _properties_2) {
            FunctionblockModel _type_19;
            FunctionBlock _functionblock_6;
            Configuration _configuration;
            boolean _tripleNotEquals_1;
            boolean _tripleNotEquals;
            FunctionblockModel _type_1 = fb_2.getType();
            FunctionBlock _functionblock = _type_1.getFunctionblock();
            Status _status = _functionblock.getStatus();
            boolean bl = _tripleNotEquals = _status != null;
            if (_tripleNotEquals) {
                _builder.append((Object)"        ");
                _builder.append((Object)"//Status Properties");
                _builder.newLine();
                FunctionblockModel _type_2 = fb_2.getType();
                FunctionBlock _functionblock_1 = _type_2.getFunctionblock();
                Status _status_1 = _functionblock_1.getStatus();
                EList _properties_3 = _status_1.getProperties();
                for (Property status : _properties_3) {
                    PropertyType _type_12;
                    PropertyType _type_6;
                    PropertyType _type_3 = status.getType();
                    boolean _isNumericType = this.isNumericType(_type_3);
                    if (_isNumericType) {
                        _builder.append((Object)"        ");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"infoModel.");
                        String _name_10 = fb_2.getName();
                        _builder.append((Object)_name_10, "        \t");
                        _builder.append((Object)".set");
                        String _name_11 = status.getName();
                        _builder.append((Object)_name_11, "        \t");
                        _builder.append((Object)"(value);");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    PropertyType _type_4 = status.getType();
                    boolean _isAlphabetical = this.isAlphabetical(_type_4);
                    if (_isAlphabetical) {
                        _builder.append((Object)"        ");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"infoModel.");
                        String _name_12 = fb_2.getName();
                        _builder.append((Object)_name_12, "        \t");
                        _builder.append((Object)".set");
                        String _name_13 = status.getName();
                        _builder.append((Object)_name_13, "        \t");
                        _builder.append((Object)"(msg);");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    FunctionblockModel _type_5 = fb_2.getType();
                    FunctionBlock _functionblock_2 = _type_5.getFunctionblock();
                    boolean _isEnum = this.isEnum(_functionblock_2, _type_6 = status.getType());
                    if (_isEnum) {
                        _builder.append((Object)"        ");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"infoModel.");
                        String _name_14 = fb_2.getName();
                        _builder.append((Object)_name_14, "        \t");
                        _builder.append((Object)".set");
                        String _name_15 = status.getName();
                        _builder.append((Object)_name_15, "        \t");
                        _builder.append((Object)"(");
                        PropertyType _type_7 = status.getType();
                        String _type_8 = this.type(_type_7);
                        _builder.append((Object)_type_8, "        \t");
                        _builder.append((Object)"::");
                        FunctionblockModel _type_9 = fb_2.getType();
                        FunctionBlock _functionblock_3 = _type_9.getFunctionblock();
                        PropertyType _type_10 = status.getType();
                        String _firstValueEnum = this.getFirstValueEnum(_functionblock_3, _type_10);
                        _builder.append((Object)_firstValueEnum, "        \t");
                        _builder.append((Object)");");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    FunctionblockModel _type_11 = fb_2.getType();
                    FunctionBlock _functionblock_4 = _type_11.getFunctionblock();
                    boolean _isEntity = this.isEntity(_functionblock_4, _type_12 = status.getType());
                    if (!_isEntity) continue;
                    _builder.append((Object)"        ");
                    _builder.append((Object)"\t");
                    PropertyType _type_13 = status.getType();
                    String _type_14 = this.type(_type_13);
                    _builder.append((Object)_type_14, "        \t");
                    _builder.append((Object)" ");
                    String _name_16 = status.getName();
                    _builder.append((Object)_name_16, "        \t");
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                    FunctionblockModel _type_15 = fb_2.getType();
                    FunctionBlock _functionblock_5 = _type_15.getFunctionblock();
                    PropertyType _type_16 = status.getType();
                    EList<Property> _entity = this.getEntity(_functionblock_5, _type_16);
                    for (Property Entity2 : _entity) {
                        PropertyType _type_17 = Entity2.getType();
                        boolean _isNumericType_1 = this.isNumericType(_type_17);
                        if (_isNumericType_1) {
                            _builder.append((Object)"        ");
                            _builder.append((Object)"\t");
                            String _name_17 = status.getName();
                            _builder.append((Object)_name_17, "        \t");
                            _builder.append((Object)".set");
                            String _name_18 = Entity2.getName();
                            _builder.append((Object)_name_18, "        \t");
                            _builder.append((Object)"(value);");
                            _builder.newLineIfNotEmpty();
                            continue;
                        }
                        PropertyType _type_18 = Entity2.getType();
                        boolean _isAlphabetical_1 = this.isAlphabetical(_type_18);
                        if (!_isAlphabetical_1) continue;
                        _builder.append((Object)"        ");
                        _builder.append((Object)"\t");
                        String _name_19 = status.getName();
                        _builder.append((Object)_name_19, "        \t");
                        _builder.append((Object)".set");
                        String _name_20 = Entity2.getName();
                        _builder.append((Object)_name_20, "        \t");
                        _builder.append((Object)"(msg);");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append((Object)"        ");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"infoModel.");
                    String _name_21 = fb_2.getName();
                    _builder.append((Object)_name_21, "        \t");
                    _builder.append((Object)".set");
                    String _name_22 = status.getName();
                    _builder.append((Object)_name_22, "        \t");
                    _builder.append((Object)"(");
                    String _name_23 = status.getName();
                    _builder.append((Object)_name_23, "        \t");
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                }
            }
            if (!(_tripleNotEquals_1 = (_configuration = (_functionblock_6 = (_type_19 = fb_2.getType()).getFunctionblock()).getConfiguration()) != null)) continue;
            _builder.append((Object)"        ");
            _builder.append((Object)"//Configuration Properties");
            _builder.newLine();
            FunctionblockModel _type_20 = fb_2.getType();
            FunctionBlock _functionblock_7 = _type_20.getFunctionblock();
            Configuration _configuration_1 = _functionblock_7.getConfiguration();
            EList _properties_4 = _configuration_1.getProperties();
            for (Property configuration : _properties_4) {
                PropertyType _type_30;
                PropertyType _type_24;
                PropertyType _type_21 = configuration.getType();
                boolean _isNumericType_2 = this.isNumericType(_type_21);
                if (_isNumericType_2) {
                    _builder.append((Object)"        ");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"infoModel.");
                    String _name_24 = fb_2.getName();
                    _builder.append((Object)_name_24, "        \t");
                    _builder.append((Object)".set");
                    String _name_25 = configuration.getName();
                    _builder.append((Object)_name_25, "        \t");
                    _builder.append((Object)"(value);");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                PropertyType _type_22 = configuration.getType();
                boolean _isAlphabetical_2 = this.isAlphabetical(_type_22);
                if (_isAlphabetical_2) {
                    _builder.append((Object)"        ");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"infoModel.");
                    String _name_26 = fb_2.getName();
                    _builder.append((Object)_name_26, "        \t");
                    _builder.append((Object)".set");
                    String _name_27 = configuration.getName();
                    _builder.append((Object)_name_27, "        \t");
                    _builder.append((Object)"(msg);");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                FunctionblockModel _type_23 = fb_2.getType();
                FunctionBlock _functionblock_8 = _type_23.getFunctionblock();
                boolean _isEnum_1 = this.isEnum(_functionblock_8, _type_24 = configuration.getType());
                if (_isEnum_1) {
                    _builder.append((Object)"        ");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"infoModel.");
                    String _name_28 = fb_2.getName();
                    _builder.append((Object)_name_28, "        \t");
                    _builder.append((Object)".set");
                    String _name_29 = configuration.getName();
                    _builder.append((Object)_name_29, "        \t");
                    _builder.append((Object)"(");
                    PropertyType _type_25 = configuration.getType();
                    String _type_26 = this.type(_type_25);
                    _builder.append((Object)_type_26, "        \t");
                    _builder.append((Object)"::");
                    FunctionblockModel _type_27 = fb_2.getType();
                    FunctionBlock _functionblock_9 = _type_27.getFunctionblock();
                    PropertyType _type_28 = configuration.getType();
                    String _firstValueEnum_1 = this.getFirstValueEnum(_functionblock_9, _type_28);
                    _builder.append((Object)_firstValueEnum_1, "        \t");
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                FunctionblockModel _type_29 = fb_2.getType();
                FunctionBlock _functionblock_10 = _type_29.getFunctionblock();
                boolean _isEntity_1 = this.isEntity(_functionblock_10, _type_30 = configuration.getType());
                if (!_isEntity_1) continue;
                _builder.append((Object)"        ");
                _builder.append((Object)"\t");
                PropertyType _type_31 = configuration.getType();
                String _type_32 = this.type(_type_31);
                _builder.append((Object)_type_32, "        \t");
                _builder.append((Object)" ");
                String _name_30 = configuration.getName();
                _builder.append((Object)_name_30, "        \t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                FunctionblockModel _type_33 = fb_2.getType();
                FunctionBlock _functionblock_11 = _type_33.getFunctionblock();
                PropertyType _type_34 = configuration.getType();
                EList<Property> _entity_1 = this.getEntity(_functionblock_11, _type_34);
                for (Property Entity_1 : _entity_1) {
                    PropertyType _type_35 = Entity_1.getType();
                    boolean _isNumericType_3 = this.isNumericType(_type_35);
                    if (_isNumericType_3) {
                        _builder.append((Object)"        ");
                        _builder.append((Object)"\t");
                        String _name_31 = configuration.getName();
                        _builder.append((Object)_name_31, "        \t");
                        _builder.append((Object)".set");
                        String _name_32 = Entity_1.getName();
                        _builder.append((Object)_name_32, "        \t");
                        _builder.append((Object)"(value);");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    PropertyType _type_36 = Entity_1.getType();
                    boolean _isAlphabetical_3 = this.isAlphabetical(_type_36);
                    if (!_isAlphabetical_3) continue;
                    _builder.append((Object)"        ");
                    _builder.append((Object)"\t");
                    String _name_33 = configuration.getName();
                    _builder.append((Object)_name_33, "        \t");
                    _builder.append((Object)".set");
                    String _name_34 = Entity_1.getName();
                    _builder.append((Object)_name_34, "        \t");
                    _builder.append((Object)"(msg);");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"        ");
                _builder.append((Object)"\t");
                _builder.append((Object)"infoModel.");
                String _name_35 = fb_2.getName();
                _builder.append((Object)_name_35, "        \t");
                _builder.append((Object)".set");
                String _name_36 = configuration.getName();
                _builder.append((Object)_name_36, "        \t");
                _builder.append((Object)"(");
                String _name_37 = configuration.getName();
                _builder.append((Object)_name_37, "        \t");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append((Object)"        ");
        _builder.newLine();
        EList _properties_5 = model.getProperties();
        for (FunctionblockProperty fb_3 : _properties_5) {
            _builder.append((Object)"        ");
            _builder.append((Object)"publish");
            String _name_38 = fb_3.getName();
            String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_38);
            _builder.append((Object)_firstUpper_1, "        ");
            _builder.append((Object)"();");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"/* END OF SAMPLE CODE */");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder.toString();
    }
}

