/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.template.runner;

import org.eclipse.vorto.codegen.api.IFileTemplate;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.xtend2.lib.StringConcatenation;

public class DockerWaitForItShTemplate
implements IFileTemplate<InformationModel> {
    public String getFileName(InformationModel context) {
        return "wait-for-it.sh";
    }

    public String getPath(InformationModel context) {
        return "generator-parent/generator-runner/docker";
    }

    public String getContent(InformationModel element, InvocationContext context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"#!/usr/bin/env bash");
        _builder.newLine();
        _builder.append((Object)"#   Use this script to test if a given TCP host/port are available");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"cmdname=$(basename $0)");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"echoerr() { if [[ $QUIET -ne 1 ]]; then echo \"$@\" 1>&2; fi }");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"usage()");
        _builder.newLine();
        _builder.append((Object)"{");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"cat << USAGE >&2");
        _builder.newLine();
        _builder.append((Object)"Usage:");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"$cmdname host:port [-s] [-t timeout] [-- command args]");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"-h HOST | --host=HOST       Host or IP under test");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"-p PORT | --port=PORT       TCP port under test");
        _builder.newLine();
        _builder.append((Object)"                                ");
        _builder.append((Object)"Alternatively, you specify the host and port as host:port");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"-s | --strict               Only execute subcommand if the test succeeds");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"-q | --quiet                Don't output any status messages");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"-t TIMEOUT | --timeout=TIMEOUT");
        _builder.newLine();
        _builder.append((Object)"                                ");
        _builder.append((Object)"Timeout in seconds, zero for no timeout");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"-- COMMAND ARGS             Execute command with args after the test finishes");
        _builder.newLine();
        _builder.append((Object)"USAGE");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"exit 1");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"wait_for()");
        _builder.newLine();
        _builder.append((Object)"{");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"if [[ $TIMEOUT -gt 0 ]]; then");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"echoerr \"$cmdname: waiting $TIMEOUT seconds for $HOST:$PORT\"");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"else");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"echoerr \"$cmdname: waiting for $HOST:$PORT without a timeout\"");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"fi");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"start_ts=$(date +%s)");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"while :");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"do");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"if [[ $ISBUSY -eq 1 ]]; then");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"nc -z $HOST $PORT");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"result=$?");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"else");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"(echo > /dev/tcp/$HOST/$PORT) >/dev/null 2>&1");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"result=$?");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"fi");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"if [[ $result -eq 0 ]]; then");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"end_ts=$(date +%s)");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"echoerr \"$cmdname: $HOST:$PORT is available after $((end_ts - start_ts)) seconds\"");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"break");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"fi");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"sleep 1");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"done");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"return $result");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"wait_for_wrapper()");
        _builder.newLine();
        _builder.append((Object)"{");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"# In order to support SIGINT during timeout: http://unix.stackexchange.com/a/57692");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"if [[ $QUIET -eq 1 ]]; then");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"timeout $BUSYTIMEFLAG $TIMEOUT $0 --quiet --child --host=$HOST --port=$PORT --timeout=$TIMEOUT &");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"else");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"timeout $BUSYTIMEFLAG $TIMEOUT $0 --child --host=$HOST --port=$PORT --timeout=$TIMEOUT &");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"fi");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"PID=$!");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"trap \"kill -INT -$PID\" INT");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"wait $PID");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"RESULT=$?");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"if [[ $RESULT -ne 0 ]]; then");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"echoerr \"$cmdname: timeout occurred after waiting $TIMEOUT seconds for $HOST:$PORT\"");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"fi");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"return $RESULT");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"# process arguments");
        _builder.newLine();
        _builder.append((Object)"while [[ $# -gt 0 ]]");
        _builder.newLine();
        _builder.append((Object)"do");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"case \"$1\" in");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"*:* )");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"hostport=(${1//:/ })");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"HOST=${hostport[0]}");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"PORT=${hostport[1]}");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"shift 1");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)";;");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"--child)");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"CHILD=1");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"shift 1");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)";;");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"-q | --quiet)");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"QUIET=1");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"shift 1");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)";;");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"-s | --strict)");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"STRICT=1");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"shift 1");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)";;");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"-h)");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"HOST=\"$2\"");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"if [[ $HOST == \"\" ]]; then break; fi");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"shift 2");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)";;");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"--host=*)");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"HOST=\"${1#*=}\"");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"shift 1");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)";;");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"-p)");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"PORT=\"$2\"");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"if [[ $PORT == \"\" ]]; then break; fi");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"shift 2");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)";;");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"--port=*)");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"PORT=\"${1#*=}\"");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"shift 1");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)";;");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"-t)");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"TIMEOUT=\"$2\"");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"if [[ $TIMEOUT == \"\" ]]; then break; fi");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"shift 2");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)";;");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"--timeout=*)");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"TIMEOUT=\"${1#*=}\"");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"shift 1");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)";;");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"--)");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"shift");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"CLI=(\"$@\")");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"break");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)";;");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"--help)");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"usage");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)";;");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"*)");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"echoerr \"Unknown argument: $1\"");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"usage");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)";;");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"esac");
        _builder.newLine();
        _builder.append((Object)"done");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"if [[ \"$HOST\" == \"\" || \"$PORT\" == \"\" ]]; then");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"echoerr \"Error: you need to provide a host and port to test.\"");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"usage");
        _builder.newLine();
        _builder.append((Object)"fi");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"TIMEOUT=${TIMEOUT:-15}");
        _builder.newLine();
        _builder.append((Object)"STRICT=${STRICT:-0}");
        _builder.newLine();
        _builder.append((Object)"CHILD=${CHILD:-0}");
        _builder.newLine();
        _builder.append((Object)"QUIET=${QUIET:-0}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"# check to see if timeout is from busybox?");
        _builder.newLine();
        _builder.append((Object)"# check to see if timeout is from busybox?");
        _builder.newLine();
        _builder.append((Object)"TIMEOUT_PATH=$(realpath $(which timeout))");
        _builder.newLine();
        _builder.append((Object)"if [[ $TIMEOUT_PATH =~ \"busybox\" ]]; then");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"ISBUSY=1");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"BUSYTIMEFLAG=\"-t\"");
        _builder.newLine();
        _builder.append((Object)"else");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"ISBUSY=0");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"BUSYTIMEFLAG=\"\"");
        _builder.newLine();
        _builder.append((Object)"fi");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"if [[ $CHILD -gt 0 ]]; then");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"wait_for");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"RESULT=$?");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"exit $RESULT");
        _builder.newLine();
        _builder.append((Object)"else");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"if [[ $TIMEOUT -gt 0 ]]; then");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"wait_for_wrapper");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"RESULT=$?");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"else");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"wait_for");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"RESULT=$?");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"fi");
        _builder.newLine();
        _builder.append((Object)"fi");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"if [[ $CLI != \"\" ]]; then");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"if [[ $RESULT -ne 0 && $STRICT -eq 1 ]]; then");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"echoerr \"$cmdname: strict mode, refusing to execute subprocess\"");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"exit $RESULT");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"fi");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"exec \"${CLI[@]}\"");
        _builder.newLine();
        _builder.append((Object)"else");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"exit $RESULT");
        _builder.newLine();
        _builder.append((Object)"fi");
        _builder.newLine();
        return _builder.toString();
    }
}

