/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.jsonschema;

import org.eclipse.vorto.codegen.jsonschema.templates.PropertiesTemplate;
import org.eclipse.vorto.core.api.model.informationmodel.FunctionblockProperty;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.vorto.plugin.generator.GeneratorException;
import org.eclipse.vorto.plugin.generator.GeneratorPluginInfo;
import org.eclipse.vorto.plugin.generator.ICodeGenerator;
import org.eclipse.vorto.plugin.generator.IGenerationResult;
import org.eclipse.vorto.plugin.generator.InvocationContext;
import org.eclipse.vorto.plugin.generator.utils.GenerationResultZip;
import org.eclipse.vorto.plugin.generator.utils.GeneratorTaskFromFileTemplate;
import org.eclipse.vorto.plugin.generator.utils.IFileTemplate;
import org.eclipse.vorto.plugin.generator.utils.IGeneratedWriter;
import org.eclipse.vorto.plugin.generator.utils.SingleGenerationResult;

public class JSONSchemaGenerator
implements ICodeGenerator {
    private static final String KEY = "jsonschema";
    private final String version = this.loadVersionFromResources();

    public IGenerationResult generate(InformationModel infomodel, InvocationContext context) throws GeneratorException {
        IGenerationResult output = this.initializeResultObject(infomodel);
        for (FunctionblockProperty fbProperty : infomodel.getProperties()) {
            new GeneratorTaskFromFileTemplate((IFileTemplate)new PropertiesTemplate()).generate((Object)fbProperty.getType(), context, (IGeneratedWriter)output);
        }
        return output;
    }

    private IGenerationResult initializeResultObject(InformationModel infomodel) {
        if (infomodel.getProperties().size() == 1) {
            return new SingleGenerationResult("application/schema+json");
        }
        return new GenerationResultZip(infomodel, KEY);
    }

    public GeneratorPluginInfo getMeta() {
        return (GeneratorPluginInfo)GeneratorPluginInfo.Builder((String)KEY).withDescription("Generates JSON Schema for Vorto Models").withName("JSON Schema").withDocumentationUrl("https://json-schema.org").withVendor("Eclipse Vorto Team").withPluginVersion(this.version).build();
    }
}

