/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.ditto.schema.tasks.template;

import java.util.List;
import org.eclipse.vorto.codegen.ditto.schema.Utils;
import org.eclipse.vorto.codegen.ditto.schema.tasks.template.EnumValidationTemplate;
import org.eclipse.vorto.codegen.ditto.schema.tasks.template.PrimitiveTypeValidationTemplate;
import org.eclipse.vorto.core.api.model.datatype.Entity;
import org.eclipse.vorto.core.api.model.datatype.Enum;
import org.eclipse.vorto.core.api.model.datatype.ObjectPropertyType;
import org.eclipse.vorto.core.api.model.datatype.PrimitivePropertyType;
import org.eclipse.vorto.core.api.model.datatype.Property;
import org.eclipse.vorto.core.api.model.datatype.PropertyType;
import org.eclipse.vorto.core.api.model.datatype.Type;
import org.eclipse.vorto.plugin.generator.InvocationContext;
import org.eclipse.vorto.plugin.generator.utils.ITemplate;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class EntityValidationTemplate
implements ITemplate<Entity> {
    private static final EnumValidationTemplate enumValidationTemplate = new EnumValidationTemplate();
    private static final PrimitiveTypeValidationTemplate primitiveTypeValidationTemplate = new PrimitiveTypeValidationTemplate();

    public String getContent(Entity entity, InvocationContext invocationContext) {
        StringConcatenation _builder = new StringConcatenation();
        String _trim = EntityValidationTemplate.handleProperties((List<Property>)entity.getProperties(), invocationContext).toString().trim();
        _builder.append(_trim);
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    public static CharSequence calculateRequired(List<Property> properties) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("\"required\": [");
        Functions.Function1 _function = it -> it.getPresence() != null && it.getPresence().isMandatory();
        Iterable _filter = IterableExtensions.filter(properties, (Functions.Function1)_function);
        boolean _hasElements = false;
        for (Property property : _filter) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)",", "");
            }
            _builder.append("\"");
            String _name = property.getName();
            _builder.append(_name);
            _builder.append("\"");
        }
        _builder.append("]");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public static CharSequence handleProperties(List<Property> properties, InvocationContext invocationContext) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (Property property : properties) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)",", "");
            }
            CharSequence _handleProperty = EntityValidationTemplate.handleProperty(property, invocationContext);
            _builder.append((Object)_handleProperty);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public static CharSequence handleProperty(Property property, InvocationContext invocationContext) {
        StringConcatenation _builder = new StringConcatenation();
        PropertyType propertyType = property.getType();
        _builder.newLineIfNotEmpty();
        if (propertyType instanceof PrimitivePropertyType) {
            PrimitivePropertyType primitiveType = (PrimitivePropertyType)propertyType;
            _builder.newLineIfNotEmpty();
            boolean _isMultiplicity = property.isMultiplicity();
            if (_isMultiplicity) {
                boolean _not;
                _builder.append("\"");
                String _name = property.getName();
                _builder.append(_name);
                _builder.append("\": {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)property.getDescription());
                boolean bl = _not = !_isNullOrEmpty;
                if (_not) {
                    _builder.append("\"description\": \"");
                    String _description = property.getDescription();
                    _builder.append(_description, "\t");
                    _builder.append("\",");
                }
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\"type\": \"array\",");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\"items\": {");
                _builder.newLine();
                _builder.append("\t\t");
                String _trim = primitiveTypeValidationTemplate.getContent(primitiveType.getType(), invocationContext).toString().trim();
                _builder.append(_trim, "\t\t");
                CharSequence _constraintsContent = Utils.getConstraintsContent(property.getConstraintRule(), invocationContext);
                _builder.append((Object)_constraintsContent, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
            } else {
                boolean _not_1;
                _builder.append("\"");
                String _name_1 = property.getName();
                _builder.append(_name_1);
                _builder.append("\": {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                boolean _isNullOrEmpty_1 = StringExtensions.isNullOrEmpty((String)property.getDescription());
                boolean bl = _not_1 = !_isNullOrEmpty_1;
                if (_not_1) {
                    _builder.append("\"description\": \"");
                    String _description_1 = property.getDescription();
                    _builder.append(_description_1, "\t");
                    _builder.append("\",");
                }
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                String _trim_1 = primitiveTypeValidationTemplate.getContent(primitiveType.getType(), invocationContext).toString().trim();
                _builder.append(_trim_1, "\t");
                CharSequence _constraintsContent_1 = Utils.getConstraintsContent(property.getConstraintRule(), invocationContext);
                _builder.append((Object)_constraintsContent_1, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("}");
                _builder.newLine();
            }
        } else if (propertyType instanceof ObjectPropertyType) {
            ObjectPropertyType objectType = (ObjectPropertyType)propertyType;
            _builder.newLineIfNotEmpty();
            Type _type = objectType.getType();
            if (_type instanceof Entity) {
                Type _type_1 = objectType.getType();
                Entity theEntity = (Entity)_type_1;
                _builder.newLineIfNotEmpty();
                boolean _isMultiplicity_1 = property.isMultiplicity();
                if (_isMultiplicity_1) {
                    boolean _not_2;
                    _builder.append("\"");
                    String _name_2 = property.getName();
                    _builder.append(_name_2);
                    _builder.append("\": {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    boolean _isNullOrEmpty_2 = StringExtensions.isNullOrEmpty((String)property.getDescription());
                    boolean bl = _not_2 = !_isNullOrEmpty_2;
                    if (_not_2) {
                        _builder.append("\"description\": \"");
                        String _description_2 = property.getDescription();
                        _builder.append(_description_2, "\t");
                        _builder.append("\",");
                    }
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\"type\": \"array\",");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\"items\": {");
                    _builder.newLine();
                    _builder.append("\t\t");
                    _builder.append("\"type\": \"object\",");
                    _builder.newLine();
                    _builder.append("\t\t");
                    _builder.append("\"properties\": {");
                    _builder.newLine();
                    _builder.append("\t\t\t");
                    CharSequence _handleProperties = EntityValidationTemplate.handleProperties((List<Property>)theEntity.getProperties(), invocationContext);
                    _builder.append((Object)_handleProperties, "\t\t\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("},");
                    _builder.newLine();
                    _builder.append("\t\t");
                    _builder.append("\"required\": [");
                    Functions.Function1 _function = it -> it.getPresence() != null && it.getPresence().isMandatory();
                    Iterable _filter = IterableExtensions.filter((Iterable)theEntity.getProperties(), (Functions.Function1)_function);
                    boolean _hasElements = false;
                    for (Property prop : _filter) {
                        if (!_hasElements) {
                            _hasElements = true;
                        } else {
                            _builder.appendImmediate((Object)",", "\t\t");
                        }
                        _builder.append("\"");
                        String _name_3 = prop.getName();
                        _builder.append(_name_3, "\t\t");
                        _builder.append("\"");
                    }
                    _builder.append("]");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                    _builder.append("}");
                    _builder.newLine();
                } else {
                    boolean _not_3;
                    _builder.append("\"");
                    String _name_4 = property.getName();
                    _builder.append(_name_4);
                    _builder.append("\": {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    boolean _isNullOrEmpty_3 = StringExtensions.isNullOrEmpty((String)property.getDescription());
                    boolean bl = _not_3 = !_isNullOrEmpty_3;
                    if (_not_3) {
                        _builder.append("\"description\": \"");
                        String _description_3 = property.getDescription();
                        _builder.append(_description_3, "\t");
                        _builder.append("\",");
                    }
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\"type\": \"object\",");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\"properties\": {");
                    _builder.newLine();
                    _builder.append("\t\t");
                    CharSequence _handleProperties_1 = EntityValidationTemplate.handleProperties((List<Property>)theEntity.getProperties(), invocationContext);
                    _builder.append((Object)_handleProperties_1, "\t\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("},");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\"required\": [");
                    Functions.Function1 _function_1 = it -> it.getPresence() != null && it.getPresence().isMandatory();
                    Iterable _filter_1 = IterableExtensions.filter((Iterable)theEntity.getProperties(), (Functions.Function1)_function_1);
                    boolean _hasElements_1 = false;
                    for (Property prop_1 : _filter_1) {
                        if (!_hasElements_1) {
                            _hasElements_1 = true;
                        } else {
                            _builder.appendImmediate((Object)",", "\t");
                        }
                        _builder.append("\"");
                        String _name_5 = prop_1.getName();
                        _builder.append(_name_5, "\t");
                        _builder.append("\"");
                    }
                    _builder.append("]");
                    _builder.newLineIfNotEmpty();
                    _builder.append("}");
                    _builder.newLine();
                }
            } else {
                Type _type_2 = objectType.getType();
                if (_type_2 instanceof Enum) {
                    Type _type_3 = objectType.getType();
                    Enum enum_ = (Enum)_type_3;
                    _builder.newLineIfNotEmpty();
                    boolean _isMultiplicity_2 = property.isMultiplicity();
                    if (_isMultiplicity_2) {
                        boolean _not_4;
                        _builder.append("\"");
                        String _name_6 = property.getName();
                        _builder.append(_name_6);
                        _builder.append("\": {");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t");
                        boolean _isNullOrEmpty_4 = StringExtensions.isNullOrEmpty((String)property.getDescription());
                        boolean bl = _not_4 = !_isNullOrEmpty_4;
                        if (_not_4) {
                            _builder.append("\"description\": \"");
                            String _description_4 = property.getDescription();
                            _builder.append(_description_4, "\t");
                            _builder.append("\",");
                        }
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t");
                        _builder.append("\"type\": \"array\",");
                        _builder.newLine();
                        _builder.append("\t");
                        _builder.append("\"items\": {");
                        _builder.newLine();
                        _builder.append("\t\t");
                        String _content = enumValidationTemplate.getContent(enum_, invocationContext);
                        _builder.append(_content, "\t\t");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t");
                        _builder.append("}");
                        _builder.newLine();
                        _builder.append("}");
                        _builder.newLine();
                    } else {
                        boolean _not_5;
                        _builder.append("\"");
                        String _name_7 = property.getName();
                        _builder.append(_name_7);
                        _builder.append("\": {");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t");
                        boolean _isNullOrEmpty_5 = StringExtensions.isNullOrEmpty((String)property.getDescription());
                        boolean bl = _not_5 = !_isNullOrEmpty_5;
                        if (_not_5) {
                            _builder.append("\"description\": \"");
                            String _description_5 = property.getDescription();
                            _builder.append(_description_5, "\t");
                            _builder.append("\",");
                        }
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t");
                        String _content_1 = enumValidationTemplate.getContent(enum_, invocationContext);
                        _builder.append(_content_1, "\t");
                        _builder.newLineIfNotEmpty();
                        _builder.append("}");
                        _builder.newLine();
                    }
                }
            }
        } else {
            boolean _not_6;
            _builder.append("\"");
            String _name_8 = property.getName();
            _builder.append(_name_8);
            _builder.append("\": {");
            _builder.newLineIfNotEmpty();
            boolean _isNullOrEmpty_6 = StringExtensions.isNullOrEmpty((String)property.getDescription());
            boolean bl = _not_6 = !_isNullOrEmpty_6;
            if (_not_6) {
                _builder.append("\"description\": \"");
                String _description_6 = property.getDescription();
                _builder.append(_description_6);
                _builder.append("\",");
            }
            _builder.newLineIfNotEmpty();
            _builder.append("\"type\": \"object\"");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }
}

