/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.ditto.schema;

import com.google.common.base.Objects;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.vorto.codegen.ditto.schema.tasks.template.ConstraintTemplate;
import org.eclipse.vorto.core.api.model.datatype.Constraint;
import org.eclipse.vorto.core.api.model.datatype.ConstraintRule;
import org.eclipse.vorto.core.api.model.datatype.Entity;
import org.eclipse.vorto.core.api.model.datatype.Enum;
import org.eclipse.vorto.core.api.model.datatype.Property;
import org.eclipse.vorto.core.api.model.functionblock.FunctionBlock;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.informationmodel.FunctionblockProperty;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.vorto.core.api.model.model.Model;
import org.eclipse.vorto.model.ModelId;
import org.eclipse.vorto.plugin.generator.InvocationContext;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class Utils {
    private static ConstraintTemplate constraintTemplate = new ConstraintTemplate();

    public static CharSequence getConstraintsContent(ConstraintRule constraintRule, InvocationContext invocationContext) {
        StringConcatenation _builder = new StringConcatenation();
        if (constraintRule != null) {
            EList _constraints = constraintRule.getConstraints();
            boolean _hasElements = false;
            for (Constraint constraint : _constraints) {
                if (!_hasElements) {
                    _hasElements = true;
                    _builder.append(",\n");
                } else {
                    _builder.appendImmediate((Object)",", "");
                }
                String _content = constraintTemplate.getContent(constraint, invocationContext);
                _builder.append(_content);
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    public static EList<FunctionblockModel> getReferencedFunctionBlocks(InformationModel infomodel) {
        BasicEList fbs = new BasicEList();
        EList _properties = infomodel.getProperties();
        for (FunctionblockProperty property : _properties) {
            Functions.Function1 _function = it -> EcoreUtil.equals((EObject)it, (EObject)property.getType());
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)fbs, (Functions.Function1)_function));
            if (!_isEmpty) continue;
            fbs.add((Object)property.getType());
        }
        return fbs;
    }

    public static EList<FunctionblockModel> getFunctionBlockHierarchy(FunctionblockModel model) {
        BasicEList fbs = new BasicEList();
        FunctionblockModel _superType = model.getSuperType();
        boolean _equals = Objects.equal((Object)_superType, null);
        if (_equals) {
            fbs.add((Object)model);
        } else {
            fbs.add((Object)model);
            fbs.addAll(Utils.getFunctionBlockHierarchy(model.getSuperType()));
        }
        return fbs;
    }

    public static Set<Entity> getReferencedEntities(InformationModel infomodel) {
        HashSet<Entity> entities = new HashSet<Entity>();
        EList _properties = infomodel.getProperties();
        for (FunctionblockProperty property : _properties) {
            EList _referencedEntities = org.eclipse.vorto.plugin.utils.Utils.getReferencedEntities((FunctionBlock)property.getType().getFunctionblock());
            for (Entity entity : _referencedEntities) {
                Functions.Function1 _function = it -> Utils.createModelId((Model)it).equals((Object)Utils.createModelId((Model)entity));
                boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter(entities, (Functions.Function1)_function));
                if (!_isEmpty) continue;
                entities.add(entity);
            }
        }
        return entities;
    }

    public static ModelId createModelId(Model model) {
        String _name = model.getName();
        String _namespace = model.getNamespace();
        String _version = model.getVersion();
        return new ModelId(_name, _namespace, _version);
    }

    public static EList<Enum> getReferencedEnums(InformationModel infomodel) {
        BasicEList enums = new BasicEList();
        EList _properties = infomodel.getProperties();
        for (FunctionblockProperty property : _properties) {
            EList _referencedEnums = org.eclipse.vorto.plugin.utils.Utils.getReferencedEnums((FunctionBlock)property.getType().getFunctionblock());
            for (Enum enumeration : _referencedEnums) {
                Functions.Function1 _function = it -> EcoreUtil.equals((EObject)it, (EObject)enumeration);
                boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)enums, (Functions.Function1)_function));
                if (!_isEmpty) continue;
                enums.add((Object)enumeration);
            }
        }
        return enums;
    }

    public static CharSequence calculateRequired(List<Property> properties) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1 _function = it -> it.getPresence() != null && it.getPresence().isMandatory();
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter(properties, (Functions.Function1)_function));
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append("required: [");
            Functions.Function1 _function_1 = it -> it.getPresence() != null && it.getPresence().isMandatory();
            Iterable _filter = IterableExtensions.filter(properties, (Functions.Function1)_function_1);
            boolean _hasElements = false;
            for (Property property : _filter) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)",", "");
                }
                String _name = property.getName();
                _builder.append(_name);
            }
            _builder.append("]");
        }
        return _builder;
    }
}

