/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.utils;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.vorto.core.api.model.datatype.Entity;
import org.eclipse.vorto.core.api.model.datatype.Enum;
import org.eclipse.vorto.core.api.model.datatype.ObjectPropertyType;
import org.eclipse.vorto.core.api.model.datatype.Property;
import org.eclipse.vorto.core.api.model.datatype.Type;
import org.eclipse.vorto.core.api.model.functionblock.FunctionBlock;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.functionblock.Operation;
import org.eclipse.vorto.core.api.model.functionblock.Param;
import org.eclipse.vorto.core.api.model.functionblock.RefParam;
import org.eclipse.vorto.core.api.model.functionblock.ReturnObjectType;
import org.eclipse.vorto.core.api.model.informationmodel.FunctionblockProperty;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModelFactory;
import org.eclipse.vorto.core.api.model.model.Model;
import org.eclipse.vorto.core.api.model.model.ModelFactory;
import org.eclipse.vorto.core.api.model.model.ModelReference;

@Deprecated
public class Utils {
    public static InformationModel toInformationModel(Model model) {
        if (model instanceof InformationModel) {
            return (InformationModel)model;
        }
        if (model instanceof FunctionblockModel) {
            return Utils.wrapFunctionBlock((FunctionblockModel)model);
        }
        throw new UnsupportedOperationException("model must either be a information- or function block model");
    }

    public static InformationModel wrapFunctionBlock(FunctionblockModel fbModel) {
        InformationModel infomodel = InformationModelFactory.eINSTANCE.createInformationModel();
        infomodel.setCategory(fbModel.getCategory());
        infomodel.setDescription(fbModel.getDescription());
        infomodel.setDisplayname(fbModel.getDisplayname());
        infomodel.setName(fbModel.getName() + "IM");
        infomodel.setNamespace(fbModel.getNamespace());
        infomodel.setVersion(fbModel.getVersion());
        FunctionblockProperty property = InformationModelFactory.eINSTANCE.createFunctionblockProperty();
        property.setType(fbModel);
        property.setName(fbModel.getName().toLowerCase());
        infomodel.getProperties().add((Object)property);
        ModelReference reference = ModelFactory.eINSTANCE.createModelReference();
        reference.setImportedNamespace(fbModel.getNamespace() + "." + fbModel.getName());
        reference.setVersion(fbModel.getVersion());
        infomodel.getReferences().add((Object)reference);
        return infomodel;
    }

    public static EList<Entity> getReferencedEntities(FunctionBlock fb) {
        BasicEList entities = new BasicEList();
        for (Type type : Utils.getReferencedTypes(fb)) {
            if (!(type instanceof Entity) || entities.contains((Object)((Entity)type))) continue;
            entities.add((Object)((Entity)type));
        }
        return entities;
    }

    public static EList<Enum> getReferencedEnums(FunctionBlock fb) {
        BasicEList enums = new BasicEList();
        for (Type type : Utils.getReferencedTypes(fb)) {
            if (!(type instanceof Enum) || enums.contains((Object)((Enum)type))) continue;
            enums.add((Object)((Enum)type));
        }
        return enums;
    }

    public static EList<Type> getReferencedTypes(Type type) {
        BasicEList types = new BasicEList();
        types.add((Object)type);
        if (type instanceof Entity) {
            Entity entityType = (Entity)type;
            for (Property property : entityType.getProperties()) {
                types.addAll(Utils.getReferencedTypes(property));
            }
            types.add((Object)entityType.getSuperType());
        }
        return types;
    }

    public static EList<Type> getReferencedTypes(Property property) {
        BasicEList types = new BasicEList();
        if (property.getType() instanceof ObjectPropertyType) {
            ObjectPropertyType objectType = (ObjectPropertyType)property.getType();
            types.add((Object)objectType.getType());
            if (objectType.getType() instanceof Entity) {
                types.addAll(Utils.getReferencedTypes((Type)((Entity)objectType.getType())));
            }
        }
        return types;
    }

    public static EList<Type> getReferencedTypes(FunctionBlock fb) {
        BasicEList types = new BasicEList();
        if (fb != null) {
            if (fb.getStatus() != null) {
                for (Property property : fb.getStatus().getProperties()) {
                    types.addAll(Utils.getReferencedTypes(property));
                }
            }
            if (fb.getConfiguration() != null) {
                for (Property property : fb.getConfiguration().getProperties()) {
                    types.addAll(Utils.getReferencedTypes(property));
                }
            }
            if (fb.getFault() != null) {
                for (Property property : fb.getFault().getProperties()) {
                    types.addAll(Utils.getReferencedTypes(property));
                }
            }
            for (Operation op : fb.getOperations()) {
                if (op.getReturnType() instanceof ReturnObjectType) {
                    types.addAll(Utils.getReferencedTypes(((ReturnObjectType)op.getReturnType()).getReturnType()));
                }
                for (Param param : op.getParams()) {
                    if (!(param instanceof RefParam)) continue;
                    types.addAll(Utils.getReferencedTypes(((RefParam)param).getType()));
                }
            }
        }
        return types;
    }
}

