/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.testutils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.vorto.codegen.testutils.ZipDiffException;

@Deprecated
public class ZipDiff {
    private static Collection<String> zipFileExtensions = Arrays.asList(".zip", ".ear", ".war", ".rar", ".jar");

    public Result diff(ZipInputStream baselineZip, ZipInputStream newZip) {
        try {
            Map<String, ZipEntry> baseline = this.getZipEntries("", baselineZip);
            Map<String, ZipEntry> compare = this.getZipEntries("", newZip);
            Collection added = compare.entrySet().stream().filter(this.notIn(baseline)).map(entry -> (String)entry.getKey()).collect(Collectors.toList());
            Collection removed = baseline.entrySet().stream().filter(this.notIn(compare)).map(entry -> (String)entry.getKey()).collect(Collectors.toList());
            Collection unchanged = baseline.entrySet().stream().filter(this.in(compare)).map(entry -> (String)entry.getKey()).collect(Collectors.toList());
            Collection changed = baseline.entrySet().stream().filter(this.changedIn(compare)).map(entry -> (String)entry.getKey()).collect(Collectors.toList());
            return new Result(added, removed, changed, unchanged);
        }
        catch (IOException e) {
            throw new ZipDiffException("Exception while taking a diff of two zip files.", e);
        }
    }

    private Predicate<Map.Entry<String, ZipEntry>> notIn(Map<String, ZipEntry> items) {
        return item -> {
            ZipEntry entry = (ZipEntry)items.get(item.getKey());
            return (entry == null || entry.isDirectory() != ((ZipEntry)item.getValue()).isDirectory()) && !((ZipEntry)item.getValue()).isDirectory();
        };
    }

    private Predicate<Map.Entry<String, ZipEntry>> changedIn(Map<String, ZipEntry> items) {
        return item -> {
            ZipEntry entry = (ZipEntry)items.get(item.getKey());
            return entry != null && entry.isDirectory() == ((ZipEntry)item.getValue()).isDirectory() && entry.getCrc() != ((ZipEntry)item.getValue()).getCrc();
        };
    }

    private Predicate<Map.Entry<String, ZipEntry>> in(Map<String, ZipEntry> items) {
        return item -> {
            ZipEntry entry = (ZipEntry)items.get(item.getKey());
            return entry != null && entry.isDirectory() == ((ZipEntry)item.getValue()).isDirectory() && entry.getCrc() == ((ZipEntry)item.getValue()).getCrc();
        };
    }

    private Map<String, ZipEntry> getZipEntries(String prefix, ZipInputStream zip) throws IOException {
        HashMap<String, ZipEntry> zipEntries = new HashMap<String, ZipEntry>();
        ZipEntry entry = zip.getNextEntry();
        while (entry != null) {
            if (this.isZipFile(entry)) {
                zipEntries.putAll(this.getZipEntries(prefix + entry.getName() + "/", this.getZipInputStream(zip, entry)));
            } else {
                zipEntries.put(prefix + entry.getName(), entry);
            }
            zip.closeEntry();
            entry = zip.getNextEntry();
        }
        return zipEntries;
    }

    private boolean isZipFile(ZipEntry entry) {
        if (entry == null || entry.getName() == null) {
            return false;
        }
        return zipFileExtensions.stream().anyMatch(extension -> entry.getName().endsWith((String)extension));
    }

    private ZipInputStream getZipInputStream(ZipInputStream zip, ZipEntry entry) throws IOException {
        byte[] zipContents = new byte[(int)entry.getSize()];
        int i = 0;
        while ((long)i < entry.getSize()) {
            zipContents[i] = (byte)zip.read();
            ++i;
        }
        return new ZipInputStream(new ByteArrayInputStream(zipContents));
    }

    public class Result {
        private Collection<String> added;
        private Collection<String> removed;
        private Collection<String> changed;
        private Collection<String> unchanged;

        public Result(Collection<String> added, Collection<String> removed, Collection<String> changed, Collection<String> unchanged) {
            this.added = added;
            this.removed = removed;
            this.changed = changed;
            this.unchanged = unchanged;
        }

        public Collection<String> getAdded() {
            return this.added;
        }

        public void setAdded(Collection<String> added) {
            this.added = added;
        }

        public Collection<String> getRemoved() {
            return this.removed;
        }

        public void setRemoved(Collection<String> removed) {
            this.removed = removed;
        }

        public Collection<String> getChanged() {
            return this.changed;
        }

        public void setChanged(Collection<String> changed) {
            this.changed = changed;
        }

        public Collection<String> getUnchanged() {
            return this.unchanged;
        }

        public void setUnchanged(Collection<String> unchanged) {
            this.unchanged = unchanged;
        }
    }
}

