/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.utils;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.vorto.model.BooleanAttributeProperty;
import org.eclipse.vorto.model.EntityModel;
import org.eclipse.vorto.model.EnumAttributeProperty;
import org.eclipse.vorto.model.EnumModel;
import org.eclipse.vorto.model.FunctionblockModel;
import org.eclipse.vorto.model.IModel;
import org.eclipse.vorto.model.IPropertyAttribute;
import org.eclipse.vorto.model.IReferenceType;
import org.eclipse.vorto.model.Infomodel;
import org.eclipse.vorto.model.ModelId;
import org.eclipse.vorto.model.ModelType;
import org.eclipse.vorto.model.PrimitiveType;

@Deprecated
public class ObjectMapperFactory {
    private static ObjectMapper mapper = null;

    public static ObjectMapper getInstance() {
        if (mapper == null) {
            mapper = new ObjectMapper();
            ObjectMapperFactory.init(mapper);
        }
        return mapper;
    }

    private static void init(ObjectMapper mapper) {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(IPropertyAttribute.class, (JsonDeserializer)new PropertyAttributeDeserializer());
        module.addDeserializer(IReferenceType.class, (JsonDeserializer)new ModelReferenceDeserializer());
        module.addDeserializer(Map.class, (JsonDeserializer)new ModelMapDeserializer());
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.registerModule((Module)module);
    }

    public static class ModelMapDeserializer
    extends StdDeserializer<HashMap<ModelId, IModel>> {
        public ModelMapDeserializer() {
            this(null);
        }

        public ModelMapDeserializer(Class<?> vc) {
            super(vc);
        }

        public HashMap<ModelId, IModel> deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
            try {
                HashMap<ModelId, IModel> deserialized = new HashMap<ModelId, IModel>();
                ObjectCodec oc = parser.getCodec();
                JsonNode node = (JsonNode)oc.readTree(parser);
                Iterator iterator = node.elements();
                while (iterator.hasNext()) {
                    JsonNode childNode = (JsonNode)iterator.next();
                    JsonNode type = childNode.get("type");
                    IModel value = null;
                    value = ModelType.valueOf((String)type.asText()).equals((Object)ModelType.InformationModel) ? (IModel)oc.treeToValue((TreeNode)childNode, Infomodel.class) : (ModelType.valueOf((String)type.asText()).equals((Object)ModelType.Functionblock) ? (IModel)oc.treeToValue((TreeNode)childNode, FunctionblockModel.class) : (ModelType.valueOf((String)type.asText()).equals((Object)ModelType.Datatype) && childNode.has("literals") ? (IModel)oc.treeToValue((TreeNode)childNode, EnumModel.class) : (IModel)oc.treeToValue((TreeNode)childNode, EntityModel.class)));
                    if (value == null) continue;
                    deserialized.put(this.getModelId(childNode.get("id").get("prettyFormat").asText()), value);
                }
                return deserialized;
            }
            catch (IOException ioEx) {
                throw new RuntimeException(ioEx);
            }
        }

        private ModelId getModelId(String modelId) {
            try {
                return ModelId.fromPrettyFormat((String)modelId);
            }
            catch (IllegalArgumentException ex) {
                int versionIndex = modelId.indexOf(":");
                return ModelId.fromReference((String)modelId.substring(0, versionIndex), (String)modelId.substring(versionIndex + 1));
            }
        }
    }

    public static class ModelReferenceDeserializer
    extends StdDeserializer<IReferenceType> {
        public ModelReferenceDeserializer() {
            this(null);
        }

        public ModelReferenceDeserializer(Class<?> vc) {
            super(vc);
        }

        public IReferenceType deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
            try {
                return (IReferenceType)parser.readValueAs(ModelId.class);
            }
            catch (IOException ioEx) {
                try {
                    return (IReferenceType)parser.readValueAs(PrimitiveType.class);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    return null;
                }
            }
        }
    }

    public static class PropertyAttributeDeserializer
    extends StdDeserializer<IPropertyAttribute> {
        public PropertyAttributeDeserializer() {
            this(null);
        }

        public PropertyAttributeDeserializer(Class<?> vc) {
            super(vc);
        }

        public IPropertyAttribute deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
            try {
                return (IPropertyAttribute)parser.readValueAs(BooleanAttributeProperty.class);
            }
            catch (IOException ioEx) {
                try {
                    return (IPropertyAttribute)parser.readValueAs(EnumAttributeProperty.class);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    return null;
                }
            }
        }
    }
}

