/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.api;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import org.apache.commons.io.FileUtils;
import org.eclipse.vorto.codegen.api.Generated;
import org.eclipse.vorto.codegen.api.ICodeGeneratorTask;
import org.eclipse.vorto.codegen.api.IGeneratedWriter;
import org.eclipse.vorto.codegen.api.InvocationContext;

public class CopyResourceTask<Context>
implements ICodeGeneratorTask<Context> {
    private URL basePath;
    private String targetPath;

    public CopyResourceTask(URL basePath, String targetPath) {
        this.basePath = basePath;
        this.targetPath = targetPath;
    }

    @Override
    public void generate(Context metaData, InvocationContext context, final IGeneratedWriter outputter) {
        try {
            Path start = Paths.get(this.basePath.toURI());
            Files.walkFileTree(start, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    outputter.write(new Generated(file.getFileName().toFile().getName(), CopyResourceTask.this.getOutputPath(file).isEmpty() ? null : CopyResourceTask.this.getOutputPath(file), FileUtils.readFileToByteArray((File)file.toFile())));
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException ioEx) {
            throw new RuntimeException(ioEx);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    private String getOutputPath(Path file) {
        String parentPath = file.getParent().toString().replace("\\", "/");
        String outputPath = parentPath.substring(parentPath.lastIndexOf(this.basePath.getPath()) + this.basePath.getPath().length());
        if (outputPath.startsWith("/")) {
            outputPath = outputPath.substring(1);
        }
        return outputPath.isEmpty() ? this.targetPath : this.targetPath + "/" + outputPath;
    }
}

