/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.bosch;

import org.eclipse.vorto.codegen.api.GenerationResultZip;
import org.eclipse.vorto.codegen.api.GeneratorInfo;
import org.eclipse.vorto.codegen.api.IGenerationResult;
import org.eclipse.vorto.codegen.api.IVortoCodeGenProgressMonitor;
import org.eclipse.vorto.codegen.api.IVortoCodeGenerator;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.api.VortoCodeGeneratorException;
import org.eclipse.vorto.codegen.hono.EclipseHonoGenerator;
import org.eclipse.vorto.codegen.prosystfi.ProSystGenerator;
import org.eclipse.vorto.codegen.utils.GenerationResultBuilder;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;

public class BoschIoTSuiteGenerator
implements IVortoCodeGenerator {
    public IGenerationResult generate(InformationModel infomodel, InvocationContext invocationContext, IVortoCodeGenProgressMonitor monitor) throws VortoCodeGeneratorException {
        GenerationResultZip output = new GenerationResultZip(infomodel, this.getServiceKey());
        GenerationResultBuilder result = GenerationResultBuilder.from((IGenerationResult)output);
        String platform = invocationContext.getConfigurationProperties().getOrDefault("language", "");
        if (platform.equalsIgnoreCase("arduino")) {
            result.append(this.generateArduino(infomodel, invocationContext, monitor));
        } else if (platform.equalsIgnoreCase("python")) {
            result.append(this.generatePython(infomodel, invocationContext, monitor));
        } else if (platform.equalsIgnoreCase("java")) {
            result.append(this.generateJava(infomodel, invocationContext, monitor));
        } else if (platform.equalsIgnoreCase("gateway")) {
            result.append(this.generateGateway(infomodel, invocationContext, monitor));
        } else {
            result.append(this.generateJava(infomodel, invocationContext, monitor));
        }
        return output;
    }

    private IGenerationResult generateJava(InformationModel infomodel, InvocationContext context, IVortoCodeGenProgressMonitor monitor) throws VortoCodeGeneratorException {
        EclipseHonoGenerator honoGenerator = new EclipseHonoGenerator();
        return honoGenerator.generate(infomodel, context, monitor);
    }

    private IGenerationResult generatePython(InformationModel infomodel, InvocationContext context, IVortoCodeGenProgressMonitor monitor) throws VortoCodeGeneratorException {
        EclipseHonoGenerator honoGenerator = new EclipseHonoGenerator();
        return honoGenerator.generate(infomodel, context, monitor);
    }

    private IGenerationResult generateArduino(InformationModel infomodel, InvocationContext context, IVortoCodeGenProgressMonitor monitor) throws VortoCodeGeneratorException {
        EclipseHonoGenerator honoGenerator = new EclipseHonoGenerator();
        return honoGenerator.generate(infomodel, context, monitor);
    }

    private IGenerationResult generateGateway(InformationModel infomodel, InvocationContext context, IVortoCodeGenProgressMonitor monitor) throws VortoCodeGeneratorException {
        ProSystGenerator generator = new ProSystGenerator();
        return generator.generate(infomodel, context, monitor);
    }

    public String getServiceKey() {
        return "boschiotsuite";
    }

    public GeneratorInfo getInfo() {
        return GeneratorInfo.basicInfo((String)"Bosch IoT Suite", (String)"Generates device code that either runs on the Bosch IoT Gateway SW or connects directly to the Bosch IoT Hub.", (String)"Eclipse Vorto Team").production().withChoiceConfigurationItem("language", "Device Platform", new GeneratorInfo.ChoiceItem[]{GeneratorInfo.ChoiceItem.of((String)"Arduino (ESP8266)", (String)"Arduino"), GeneratorInfo.ChoiceItem.of((String)"Python (v2)", (String)"Python"), GeneratorInfo.ChoiceItem.of((String)"Java", (String)"Java"), GeneratorInfo.ChoiceItem.of((String)"Bosch IoT Gateway Software", (String)"gateway")});
    }
}

