/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.versions.manipulation;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.tycho.model.ProductConfiguration;
import org.eclipse.tycho.versions.engine.MetadataManipulator;
import org.eclipse.tycho.versions.engine.ProjectMetadata;
import org.eclipse.tycho.versions.engine.VersionChange;
import org.eclipse.tycho.versions.engine.Versions;
import org.eclipse.tycho.versions.manipulation.ProductFileManipulator;
import org.eclipse.tycho.versions.pom.MutablePomFile;

@Component(role=MetadataManipulator.class, hint="eclipse-application")
public class EclipseApplicationProductFileManipulator
extends ProductFileManipulator {
    @Override
    public void applyChange(ProjectMetadata project, VersionChange change, Set<VersionChange> allChanges) {
        if (this.isEclipseApplication(project)) {
            this.applyChangeToProduct(project, this.getProductConfiguration(project), this.getProductFileName(project), change);
        }
    }

    @Override
    public Collection<String> validateChange(ProjectMetadata project, VersionChange change) {
        if (this.isEclipseApplication(project)) {
            ProductConfiguration product = this.getProductConfiguration(project);
            if (this.isSameProject(project, change.getProject()) && change.getVersion().equals(product.getVersion())) {
                String error = Versions.validateOsgiVersion(change.getNewVersion(), this.getProductFile(project));
                return error != null ? Collections.singleton(error) : null;
            }
        }
        return null;
    }

    private ProductConfiguration getProductConfiguration(ProjectMetadata project) {
        ProductConfiguration product = project.getMetadata(ProductConfiguration.class);
        if (product == null) {
            File file = this.getProductFile(project);
            try {
                product = ProductConfiguration.read((File)file);
                project.putMetadata(product);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not read product configuration file " + file, e);
            }
        }
        return product;
    }

    private File getProductFile(ProjectMetadata project) {
        return new File(project.getBasedir(), this.getProductFileName(project));
    }

    private String getProductFileName(ProjectMetadata project) {
        MutablePomFile pom = project.getMetadata(MutablePomFile.class);
        return pom.getArtifactId() + ".product";
    }

    private boolean isEclipseApplication(ProjectMetadata project) {
        String packaging = project.getMetadata(MutablePomFile.class).getPackaging();
        return this.isEclipseApplication(packaging);
    }

    private boolean isEclipseApplication(String packaging) {
        return "eclipse-application".equals(packaging);
    }

    @Override
    public void writeMetadata(ProjectMetadata project) throws IOException {
        ProductConfiguration product = project.getMetadata(ProductConfiguration.class);
        if (product != null) {
            ProductConfiguration.write((ProductConfiguration)product, (File)this.getProductFile(project));
        }
    }
}

