/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.versions.manipulation;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.tycho.model.Category;
import org.eclipse.tycho.model.PluginRef;
import org.eclipse.tycho.model.UpdateSite;
import org.eclipse.tycho.versions.engine.MetadataManipulator;
import org.eclipse.tycho.versions.engine.ProjectMetadata;
import org.eclipse.tycho.versions.engine.VersionChange;
import org.eclipse.tycho.versions.manipulation.AbstractMetadataManipulator;
import org.eclipse.tycho.versions.manipulation.SiteXmlManipulator;
import org.eclipse.tycho.versions.pom.MutablePomFile;

@Component(role=MetadataManipulator.class, hint="eclipse-repository")
public class CategoryXmlManipulator
extends AbstractMetadataManipulator {
    @Override
    public void applyChange(ProjectMetadata project, VersionChange change, Set<VersionChange> allChanges) {
        if (this.isEclipseRepository(project)) {
            if (this.isFeature(change.getProject().getPackaging())) {
                this.updateFeatureReferences(change, project);
            } else if (this.isBundle(change.getProject())) {
                this.updatePluginReferences(change, project);
            }
        }
    }

    private void updateFeatureReferences(VersionChange featureVersionChange, ProjectMetadata project) {
        Category categoryXml = this.getCategoryXml(project);
        if (categoryXml == null) {
            return;
        }
        for (UpdateSite.SiteFeatureRef feature : categoryXml.getFeatures()) {
            if (!featureVersionChange.getArtifactId().equals(feature.getId()) || !featureVersionChange.getVersion().equals(feature.getVersion())) continue;
            this.logger.info("  category.xml//site/feature[@id=" + feature.getId() + "]/@version: " + featureVersionChange.getVersion() + " => " + featureVersionChange.getNewVersion());
            feature.setVersion(featureVersionChange.getNewVersion());
            String oldUrl = feature.getUrl();
            if (oldUrl == null) continue;
            String newUrl = SiteXmlManipulator.rewriteFeatureUrl(oldUrl, featureVersionChange);
            this.logger.info("  category.xml//site/feature[@id=" + feature.getId() + "]/@url: " + oldUrl + " => " + newUrl);
            feature.setUrl(newUrl);
        }
    }

    private void updatePluginReferences(VersionChange pluginVersionChange, ProjectMetadata project) {
        Category categoryXml = this.getCategoryXml(project);
        if (categoryXml == null) {
            return;
        }
        for (PluginRef plugin : categoryXml.getPlugins()) {
            if (!pluginVersionChange.getArtifactId().equals(plugin.getId()) || !pluginVersionChange.getVersion().equals(plugin.getVersion())) continue;
            this.logger.info("  category.xml//site/bundle[@id=" + plugin.getId() + "]/@version: " + pluginVersionChange.getVersion() + " => " + pluginVersionChange.getNewVersion());
            plugin.setVersion(pluginVersionChange.getNewVersion());
        }
    }

    private Category getCategoryXml(ProjectMetadata project) {
        Category categoryXml = project.getMetadata(Category.class);
        if (categoryXml == null) {
            File file = new File(project.getBasedir(), "category.xml");
            if (!file.isFile()) {
                return null;
            }
            try {
                categoryXml = Category.read((File)file);
                project.putMetadata(categoryXml);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not read categories from " + file, e);
            }
        }
        return categoryXml;
    }

    private boolean isEclipseRepository(ProjectMetadata project) {
        MutablePomFile pom = project.getMetadata(MutablePomFile.class);
        return "eclipse-repository".equals(pom.getPackaging());
    }

    @Override
    public void writeMetadata(ProjectMetadata project) throws IOException {
        File basedir = project.getBasedir();
        Category categoryXml = project.getMetadata(Category.class);
        if (categoryXml != null) {
            Category.write((Category)categoryXml, (File)new File(basedir, "category.xml"));
        }
    }

    @Override
    public Collection<String> validateChange(ProjectMetadata project, VersionChange change) {
        return null;
    }
}

