/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.surefire;

import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.classpath.ClasspathEntry;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestFramework {
    public static final String TEST_JUNIT = "org.junit";
    public static final String TEST_JUNIT4 = "org.junit4";

    public String getTestFramework(List<ClasspathEntry> classpath) throws MojoExecutionException {
        String result = null;
        for (ClasspathEntry entry : classpath) {
            ArtifactKey key = entry.getArtifactKey();
            String testFramework = TestFramework.getTestFramework(key.getId(), key.getVersion(), result);
            if (testFramework == null) continue;
            result = testFramework;
        }
        if (result != null) {
            return result;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getTestFramework(String symbolicName, String versionStr, String currentTestFramework) {
        if (TEST_JUNIT.equals(symbolicName)) {
            Version version = Version.parseVersion((String)versionStr);
            if (version.getMajor() >= 4) return TEST_JUNIT4;
            if (TEST_JUNIT4.equals(currentTestFramework)) return null;
            return TEST_JUNIT;
        }
        if (!TEST_JUNIT4.equals(symbolicName)) return null;
        return TEST_JUNIT4;
    }
}

