/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.buildversion;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.eclipse.tycho.ArtifactDescriptor;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.buildversion.BuildQualifierMojo;
import org.eclipse.tycho.buildversion.TimestampFinder;
import org.eclipse.tycho.core.ArtifactDependencyVisitor;
import org.eclipse.tycho.core.FeatureDescription;
import org.eclipse.tycho.core.PluginDescription;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.osgi.framework.Version;

@Mojo(name="build-qualifier-aggregator", defaultPhase=LifecyclePhase.VALIDATE, threadSafe=true)
public class BuildQualifierAggregatorMojo
extends BuildQualifierMojo {
    private final TimestampFinder timestampFinder = new TimestampFinder();

    @Override
    protected Date getBuildTimestamp() throws MojoExecutionException {
        Date timestamp = super.getBuildTimestamp();
        if (this.timestampProvider == null) {
            return timestamp;
        }
        final Date[] latestTimestamp = new Date[]{timestamp};
        TychoProject projectType = (TychoProject)this.projectTypes.get(this.project.getPackaging());
        if (projectType == null) {
            throw new IllegalStateException("Unknown or unsupported packaging type " + this.packaging);
        }
        final ReactorProject thisProject = DefaultReactorProject.adapt((MavenProject)this.project);
        projectType.getDependencyWalker(this.project).walk(new ArtifactDependencyVisitor(){

            public boolean visitFeature(FeatureDescription feature) {
                if (feature.getFeatureRef() == null || thisProject.equals(feature.getMavenProject())) {
                    return true;
                }
                this.visitArtifact((ArtifactDescriptor)feature);
                return false;
            }

            public void visitPlugin(PluginDescription plugin) {
                if (plugin.getPluginRef() == null || thisProject.equals(plugin.getMavenProject())) {
                    return;
                }
                this.visitArtifact((ArtifactDescriptor)plugin);
            }

            private void visitArtifact(ArtifactDescriptor artifact) {
                ReactorProject otherProject = artifact.getMavenProject();
                String otherVersion = otherProject != null ? otherProject.getExpandedVersion() : artifact.getKey().getVersion();
                Version v = Version.parseVersion((String)otherVersion);
                String otherQualifier = v.getQualifier();
                if (otherQualifier != null) {
                    Date timestamp = this.parseQualifier(otherQualifier);
                    if (timestamp != null) {
                        if (latestTimestamp[0].compareTo(timestamp) < 0) {
                            if (BuildQualifierAggregatorMojo.this.getLog().isDebugEnabled()) {
                                BuildQualifierAggregatorMojo.this.getLog().debug((CharSequence)("Found '" + BuildQualifierAggregatorMojo.this.format.format(timestamp) + "' from qualifier '" + otherQualifier + "' for artifact " + artifact));
                            }
                            latestTimestamp[0] = timestamp;
                        }
                    } else {
                        BuildQualifierAggregatorMojo.this.getLog().debug((CharSequence)("Could not parse qualifier timestamp " + otherQualifier));
                    }
                }
            }

            private Date parseQualifier(String qualifier) {
                Date timestamp = this.parseQualifier(qualifier, BuildQualifierAggregatorMojo.this.format);
                if (timestamp != null) {
                    return timestamp;
                }
                return this.discoverTimestamp(qualifier);
            }

            private Date parseQualifier(String qualifier, SimpleDateFormat format) {
                ParsePosition pos = new ParsePosition(0);
                Date timestamp = format.parse(qualifier, pos);
                if (timestamp != null && pos.getIndex() == qualifier.length()) {
                    return timestamp;
                }
                return null;
            }

            private Date discoverTimestamp(String qualifier) {
                return BuildQualifierAggregatorMojo.this.timestampFinder.findInString(qualifier);
            }
        });
        return latestTimestamp[0];
    }
}

