/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.packaging;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.util.ArchiveEntryUtils;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.SelectorUtils;
import org.codehaus.plexus.util.io.InputStreamFacade;
import org.codehaus.plexus.util.io.RawInputStreamFacade;
import org.eclipse.pde.internal.swt.tools.IconExe;
import org.eclipse.tycho.ArtifactDescriptor;
import org.eclipse.tycho.core.ArtifactDependencyVisitor;
import org.eclipse.tycho.core.ArtifactDependencyWalker;
import org.eclipse.tycho.core.PluginDescription;
import org.eclipse.tycho.core.osgitools.BundleReader;
import org.eclipse.tycho.core.shared.TargetEnvironment;
import org.eclipse.tycho.core.utils.TychoProjectUtils;
import org.eclipse.tycho.locking.facade.FileLockService;
import org.eclipse.tycho.locking.facade.FileLocker;
import org.eclipse.tycho.model.BundleConfiguration;
import org.eclipse.tycho.model.ProductConfiguration;
import org.eclipse.tycho.packaging.AbstractTychoPackagingMojo;
import org.eclipse.tycho.packaging.ProductAssembler;

@Mojo(name="product-export", threadSafe=true)
public class ProductExportMojo
extends AbstractTychoPackagingMojo {
    private static final Object LOCK = new Object();
    @Parameter(property="productConfiguration", defaultValue="${project.basedir}/${project.artifactId}.product")
    private File productConfigurationFile;
    @Parameter(defaultValue="${productConfiguration}/../p2.inf")
    private File p2inf;
    @Parameter(defaultValue="${project.build.directory}/${project.artifactId}.product")
    private File expandedProductFile;
    private ProductConfiguration productConfiguration;
    @Parameter
    private TargetEnvironment[] environments;
    @Parameter(property="tycho.product.createArchive", defaultValue="true")
    private boolean createProductArchive;
    @Parameter(defaultValue="false")
    private boolean includeSources;
    @Parameter(defaultValue="true")
    private boolean separateEnvironments = true;
    @Parameter(defaultValue="false")
    private boolean forcePackedDependencies;
    @Component
    private BundleReader manifestReader;
    @Component
    private FileLockService fileLockService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        Object object = LOCK;
        synchronized (object) {
            this.getLog().warn((CharSequence)"The packaging type 'eclipse-application' is deprecated; use 'eclipse-repository' instead. See http://wiki.eclipse.org/Tycho_Messages_Explained#Eclipse_Application");
            if (!this.productConfigurationFile.exists()) {
                throw new MojoExecutionException("Product configuration file not found " + this.productConfigurationFile.getAbsolutePath());
            }
            try {
                this.getLog().debug((CharSequence)"Parsing productConfiguration");
                this.productConfiguration = ProductConfiguration.read((File)this.productConfigurationFile);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error reading product configuration file", (Exception)e);
            }
            boolean implicitTargetEnvironment = TychoProjectUtils.getTargetPlatformConfiguration((MavenProject)this.project).isImplicitTargetEnvironment();
            if (this.productConfiguration.includeLaunchers() && implicitTargetEnvironment && this.environments == null) {
                throw new MojoFailureException("Product includes native launcher but no target environment was specified");
            }
            if (this.separateEnvironments) {
                for (TargetEnvironment environment : this.getEnvironments()) {
                    File target = this.getTarget(environment);
                    File targetEclipse = new File(target, "eclipse");
                    targetEclipse.mkdirs();
                    this.generateDotEclipseProduct(targetEclipse);
                    this.generateConfigIni(environment, targetEclipse);
                    this.includeRootFiles(environment, targetEclipse);
                    ProductAssembler assembler = new ProductAssembler(this.plexus, this.manifestReader, targetEclipse, environment);
                    assembler.setIncludeSources(this.includeSources);
                    this.getDependencyWalker(environment).walk((ArtifactDependencyVisitor)assembler);
                    if (this.productConfiguration.includeLaunchers()) {
                        this.copyExecutable(environment, targetEclipse);
                    }
                    if (!this.createProductArchive) continue;
                    this.createProductArchive(target, this.toString(environment));
                }
            } else {
                File target = this.getTarget(null);
                File targetEclipse = new File(target, "eclipse");
                targetEclipse.mkdirs();
                this.generateDotEclipseProduct(targetEclipse);
                this.generateConfigIni(null, targetEclipse);
                for (TargetEnvironment environment : this.getEnvironments()) {
                    this.includeRootFiles(environment, targetEclipse);
                }
                ProductAssembler assembler = new ProductAssembler(this.plexus, this.manifestReader, targetEclipse, null);
                assembler.setIncludeSources(this.includeSources);
                if (this.forcePackedDependencies) {
                    assembler.setUnpackFeatures(false);
                    assembler.setUnpackPlugins(false);
                }
                this.getDependencyWalker().walk((ArtifactDependencyVisitor)assembler);
                if (this.productConfiguration.includeLaunchers()) {
                    for (TargetEnvironment environment : this.getEnvironments()) {
                        this.copyExecutable(environment, targetEclipse);
                    }
                }
                if (this.createProductArchive) {
                    this.createProductArchive(target, null);
                }
            }
            try {
                ProductConfiguration.write((ProductConfiguration)this.productConfiguration, (File)this.expandedProductFile);
                if (this.p2inf.canRead()) {
                    FileUtils.copyFile((File)this.p2inf, (File)new File(this.expandedProductFile.getParentFile(), this.p2inf.getName()));
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error writing expanded product configuration file", (Exception)e);
            }
            if (!this.createProductArchive || this.environments != null) {
                this.project.getArtifact().setFile(this.expandedProductFile);
            }
        }
    }

    private ArtifactDependencyWalker getDependencyWalker(TargetEnvironment environment) {
        return this.getTychoProjectFacet("eclipse-application").getDependencyWalker(this.project, environment);
    }

    private List<TargetEnvironment> getEnvironments() {
        if (this.environments != null) {
            this.getLog().warn((CharSequence)"tycho-packaging-plugin <environments/> is deprecated. use target-platform-configuration <environments/>.");
            return Arrays.asList(this.environments);
        }
        return TychoProjectUtils.getTargetPlatformConfiguration((MavenProject)this.project).getEnvironments();
    }

    private File getTarget(TargetEnvironment environment) {
        File target = this.separateEnvironments ? new File(this.project.getBuild().getDirectory(), this.toString(environment)) : new File(this.project.getBuild().getDirectory(), "product");
        target.mkdirs();
        return target;
    }

    private String toString(TargetEnvironment environment) {
        StringBuilder sb = new StringBuilder();
        sb.append(environment.getOs()).append('.').append(environment.getWs()).append('.').append(environment.getArch());
        return sb.toString();
    }

    private void includeRootFiles(TargetEnvironment environment, File target) throws MojoExecutionException {
        Properties properties = this.project.getProperties();
        String generatedBuildProperties = properties.getProperty("generatedBuildProperties");
        this.getLog().debug((CharSequence)("includeRootFiles from " + generatedBuildProperties));
        if (generatedBuildProperties == null) {
            return;
        }
        Properties rootProperties = new Properties();
        try (FileInputStream stream = new FileInputStream(new File(this.project.getBasedir(), generatedBuildProperties));){
            rootProperties.load(stream);
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("Error including root files for product", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error including root files for product", (Exception)e);
        }
        String config = this.getConfig(environment);
        String root = "root";
        String rootConfig = "root." + config;
        String rootFolder = "root.folder.";
        String rootConfigFolder = "root." + config + ".folder.";
        Set<Map.Entry<Object, Object>> entrySet = rootProperties.entrySet();
        for (Map.Entry<Object, Object> entry : entrySet) {
            String subFolder;
            String key = ((String)entry.getKey()).trim();
            if (root.equals(key)) {
                this.handleRootEntry(target, (String)entry.getValue(), null);
                continue;
            }
            if (rootConfig.equals(key)) {
                this.handleRootEntry(target, (String)entry.getValue(), null);
                continue;
            }
            if (key.startsWith(rootFolder)) {
                subFolder = ((String)entry.getKey()).substring(rootFolder.length());
                this.handleRootEntry(target, (String)entry.getValue(), subFolder);
                continue;
            }
            if (key.startsWith(rootConfigFolder)) {
                subFolder = ((String)entry.getKey()).substring(rootConfigFolder.length());
                this.handleRootEntry(target, (String)entry.getValue(), subFolder);
                continue;
            }
            this.getLog().debug((CharSequence)("ignoring property " + (String)entry.getKey() + "=" + (String)entry.getValue()));
        }
    }

    private void handleRootEntry(File target, String rootFileEntries, String subFolder) throws MojoExecutionException {
        StringTokenizer t = new StringTokenizer(rootFileEntries, ",");
        File destination = target;
        if (subFolder != null) {
            destination = new File(target, subFolder);
        }
        while (t.hasMoreTokens()) {
            String rootFileEntry = t.nextToken();
            String fileName = rootFileEntry.trim();
            boolean isAbsolute = false;
            if (fileName.startsWith("absolute:")) {
                isAbsolute = true;
                fileName = fileName.substring("absolute:".length());
            }
            if (fileName.startsWith("file")) {
                fileName = fileName.substring("file:".length());
            }
            File source = null;
            source = !isAbsolute ? new File(this.project.getBasedir(), fileName) : new File(fileName);
            try {
                if (source.isFile()) {
                    FileUtils.copyFileToDirectory((File)source, (File)destination);
                    continue;
                }
                if (source.isDirectory()) {
                    FileUtils.copyDirectoryStructure((File)source, (File)destination);
                    continue;
                }
                this.getLog().warn((CharSequence)("Skipping root entry " + rootFileEntry));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Coult not copy root entry " + fileName, (Exception)e);
            }
        }
    }

    private String getConfig(TargetEnvironment environment) {
        String os = environment.getOs();
        String ws = environment.getWs();
        String arch = environment.getArch();
        StringBuffer config = new StringBuffer(os).append(".").append(ws).append(".").append(arch);
        return config.toString();
    }

    private void createProductArchive(File target, String classifier) throws MojoExecutionException {
        ZipArchiver zipper;
        try {
            zipper = (ZipArchiver)this.plexus.lookup(ZipArchiver.ROLE, "zip");
        }
        catch (ComponentLookupException e) {
            throw new MojoExecutionException("Unable to resolve ZipArchiver", (Exception)((Object)e));
        }
        StringBuilder filename = new StringBuilder(this.project.getBuild().getFinalName());
        if (this.separateEnvironments) {
            filename.append('-').append(classifier);
        }
        filename.append(".zip");
        File destFile = new File(this.project.getBuild().getDirectory(), filename.toString());
        try {
            zipper.addDirectory(target);
            zipper.setDestFile(destFile);
            zipper.createArchive();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error packing product", e);
        }
        if (this.separateEnvironments) {
            this.projectHelper.attachArtifact(this.project, destFile, classifier);
        } else {
            this.project.getArtifact().setFile(destFile);
        }
    }

    private void generateDotEclipseProduct(File target) throws MojoExecutionException {
        this.getLog().debug((CharSequence)"Generating .eclipseproduct");
        Properties props = new Properties();
        this.setPropertyIfNotNull(props, "version", this.productConfiguration.getVersion());
        this.setPropertyIfNotNull(props, "name", this.productConfiguration.getName());
        this.setPropertyIfNotNull(props, "id", this.productConfiguration.getId());
        File eclipseproduct = new File(target, ".eclipseproduct");
        try {
            FileOutputStream fos = new FileOutputStream(eclipseproduct);
            props.store(fos, "Eclipse Product File");
            fos.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating .eclipseproduct file.", (Exception)e);
        }
    }

    private void generateConfigIni(TargetEnvironment environment, File target) throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)"Generating config.ini");
        Properties props = new Properties();
        String id = this.productConfiguration.getProduct();
        if (id != null) {
            String splash = id.split("\\.")[0];
            this.setPropertyIfNotNull(props, "osgi.splashPath", "platform:/base/plugins/" + splash);
        }
        this.setPropertyIfNotNull(props, "eclipse.product", id);
        this.setPropertyIfNotNull(props, "osgi.bundles.defaultStartLevel", "4");
        this.generateOSGiBundles(props, environment);
        File configsFolder = new File(target, "configuration");
        configsFolder.mkdirs();
        File configIni = new File(configsFolder, "config.ini");
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(configIni);
            props.store(fos, "Product Runtime Configuration File");
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Error creating .eclipseproduct file.", (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(fos);
                throw throwable;
            }
        }
        IOUtil.close((OutputStream)fos);
    }

    private void generateOSGiBundles(Properties props, TargetEnvironment environment) throws MojoFailureException {
        HashMap<String, BundleConfiguration> bundlesToStart = this.productConfiguration.getPluginConfiguration();
        if (bundlesToStart == null) {
            bundlesToStart = new HashMap<String, BundleConfiguration>();
            bundlesToStart.put("org.eclipse.equinox.common", new BundleConfiguration("org.eclipse.equinox.common", 2, true));
            bundlesToStart.put("org.eclipse.core.runtime", new BundleConfiguration("org.eclipse.core.runtime", -1, true));
        }
        LinkedHashMap<String, PluginDescription> bundles = new LinkedHashMap<String, PluginDescription>(this.getBundles(environment));
        StringBuilder osgiBundles = new StringBuilder();
        for (PluginDescription plugin : bundles.values()) {
            String bundleId = plugin.getKey().getId();
            if ("org.eclipse.osgi".equals(bundleId)) continue;
            if (osgiBundles.length() > 0) {
                osgiBundles.append(',');
            }
            osgiBundles.append(bundleId);
            BundleConfiguration startup = (BundleConfiguration)bundlesToStart.get(bundleId);
            if (startup == null) continue;
            osgiBundles.append('@');
            if (startup.getStartLevel() > 0) {
                osgiBundles.append(startup.getStartLevel());
            }
            if (!startup.isAutoStart()) continue;
            if (startup.getStartLevel() > 0) {
                osgiBundles.append(':');
            }
            osgiBundles.append("start");
        }
        this.setPropertyIfNotNull(props, "osgi.bundles", osgiBundles.toString());
    }

    private Map<String, PluginDescription> getBundles(TargetEnvironment environment) {
        final LinkedHashMap<String, PluginDescription> bundles = new LinkedHashMap<String, PluginDescription>();
        this.getDependencyWalker(environment).walk(new ArtifactDependencyVisitor(){

            public void visitPlugin(PluginDescription plugin) {
                bundles.put(plugin.getKey().getId(), plugin);
            }
        });
        return bundles;
    }

    private void copyExecutable(TargetEnvironment environment, File target) throws MojoExecutionException, MojoFailureException {
        Object eclipseApp;
        this.getLog().debug((CharSequence)"Creating launcher");
        ArtifactDescriptor artifact = this.getDependencyArtifacts().getArtifact("eclipse-feature", "org.eclipse.equinox.executable", null);
        if (artifact == null) {
            throw new MojoExecutionException("Native launcher is not found for " + environment.toString());
        }
        File location = artifact.getLocation();
        String os = environment.getOs();
        String ws = environment.getWs();
        String arch = environment.getArch();
        try {
            String launcherRelPath = "bin/" + ws + "/" + os + "/" + arch + "/";
            String excludes = "**/eclipsec*";
            if (location.isDirectory()) {
                this.copyDirectory(new File(location, launcherRelPath), target, excludes);
            } else {
                this.unzipDirectory(location, launcherRelPath, target, excludes);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to copy launcher executable", (Exception)e);
        }
        File launcher = this.getLauncher(environment, target);
        try {
            this.getLog().debug((CharSequence)"running chmod");
            ArchiveEntryUtils.chmod((File)launcher, (int)493);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Unable to make launcher being executable", (Exception)((Object)e));
        }
        File osxEclipseApp = null;
        if (this.productConfiguration.getLauncher() != null && this.productConfiguration.getLauncher().getName() != null) {
            String launcherName;
            String newName = launcherName = this.productConfiguration.getLauncher().getName();
            if ("win32".equals(os)) {
                String extension = FileUtils.getExtension((String)launcher.getAbsolutePath());
                newName = launcherName + "." + extension;
            } else if ("macosx".equals(os)) {
                newName = "eclipse";
            }
            this.getLog().debug((CharSequence)("Renaming launcher to " + newName));
            File newLauncher = new File(launcher.getParentFile(), newName);
            if (!launcher.renameTo(newLauncher)) {
                throw new MojoExecutionException("Could not rename native launcher to " + newName);
            }
            launcher = newLauncher;
            if ("macosx".equals(os)) {
                newName = launcherName + ".app";
                this.getLog().debug((CharSequence)("Renaming Eclipse.app to " + newName));
                eclipseApp = new File(target, "Eclipse.app");
                osxEclipseApp = new File(((File)eclipseApp).getParentFile(), newName);
                ((File)eclipseApp).renameTo(osxEclipseApp);
            }
        }
        if (this.productConfiguration.getLauncher() != null) {
            File targetXPM;
            File sourceXPM;
            String icon;
            if ("win32".equals(os)) {
                this.getLog().debug((CharSequence)"win32 icons");
                List icons = this.productConfiguration.getW32Icons();
                if (icons != null) {
                    this.getLog().debug((CharSequence)icons.toString());
                    try {
                        String[] args = new String[icons.size() + 1];
                        args[0] = launcher.getAbsolutePath();
                        int pos = 1;
                        eclipseApp = icons.iterator();
                        while (eclipseApp.hasNext()) {
                            String string;
                            args[pos] = string = (String)eclipseApp.next();
                            ++pos;
                        }
                        IconExe.main(args);
                    }
                    catch (Exception e) {
                        throw new MojoExecutionException("Unable to replace icons", e);
                    }
                } else {
                    this.getLog().debug((CharSequence)"icons is null");
                }
            } else if ("linux".equals(os)) {
                icon = this.productConfiguration.getLinuxIcon();
                if (icon != null) {
                    try {
                        sourceXPM = new File(this.project.getBasedir(), this.removeFirstSegment(icon));
                        targetXPM = new File(launcher.getParentFile(), "icon.xpm");
                        FileUtils.copyFile((File)sourceXPM, (File)targetXPM);
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException("Unable to create ico.xpm", (Exception)e);
                    }
                }
            } else if ("freebsd".equals(os)) {
                icon = this.productConfiguration.getFreeBSDIcon();
                if (icon != null) {
                    try {
                        sourceXPM = new File(this.project.getBasedir(), this.removeFirstSegment(icon));
                        targetXPM = new File(launcher.getParentFile(), "icon.xpm");
                        FileUtils.copyFile((File)sourceXPM, (File)targetXPM);
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException("Unable to create ico.xpm", (Exception)e);
                    }
                }
            } else if ("macosx".equals(os) && (icon = this.productConfiguration.getMacIcon()) != null) {
                try {
                    if (osxEclipseApp == null) {
                        osxEclipseApp = new File(target, "Eclipse.app");
                    }
                    File source = new File(this.project.getBasedir(), this.removeFirstSegment(icon));
                    File targetFolder = new File(osxEclipseApp, "/Resources/" + source.getName());
                    FileUtils.copyFile((File)source, (File)targetFolder);
                    File iniFile = new File(osxEclipseApp + "/Contents/MacOS/eclipse.ini");
                    if (iniFile.exists() && iniFile.canWrite()) {
                        StringBuffer buf = this.readFileToString(iniFile);
                        int pos = buf.indexOf("Eclipse.icns");
                        buf.replace(pos, pos + 12, source.getName());
                        this.writeStringToFile(iniFile, buf.toString());
                    }
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Unable to create macosx icon", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStringToFile(File iniFile, String string) throws IOException {
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(iniFile));
        try {
            IOUtil.copy((String)string, (OutputStream)os);
        }
        finally {
            IOUtil.close((OutputStream)os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer readFileToString(File iniFile) throws IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(iniFile));
        try {
            StringWriter buffer = new StringWriter();
            IOUtil.copy((InputStream)is, (Writer)buffer, (String)"UTF-8");
            StringBuffer stringBuffer = buffer.getBuffer();
            return stringBuffer;
        }
        finally {
            IOUtil.close((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unzipDirectory(File source, String sourceRelPath, File target, String excludes) throws IOException {
        FileLocker locker = this.fileLockService.getFileLocker(source);
        locker.lock();
        try (ZipFile zip = new ZipFile(source);){
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                String name;
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() || !(name = entry.getName()).startsWith(sourceRelPath) || SelectorUtils.matchPath((String)excludes, (String)name)) continue;
                File targetFile = new File(target, name.substring(sourceRelPath.length()));
                targetFile.getParentFile().mkdirs();
                FileUtils.copyStreamToFile((InputStreamFacade)new RawInputStreamFacade(zip.getInputStream(entry)), (File)targetFile);
            }
        }
        finally {
            locker.release();
        }
    }

    private void copyDirectory(File source, File target, String excludes) throws IOException {
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(source);
        ds.setExcludes(new String[]{excludes});
        ds.scan();
        for (String relPath : ds.getIncludedFiles()) {
            File targetFile = new File(target, relPath);
            targetFile.getParentFile().mkdirs();
            FileUtils.copyFile((File)new File(source, relPath), (File)targetFile);
        }
    }

    private String removeFirstSegment(String path) {
        int idx = path.indexOf(47);
        if (idx < 0) {
            return null;
        }
        if (idx == 0) {
            idx = path.indexOf(47, 1);
        }
        if (idx < 0) {
            return null;
        }
        return path.substring(idx);
    }

    private File getLauncher(TargetEnvironment environment, File target) throws MojoExecutionException {
        String os = environment.getOs();
        if ("win32".equals(os)) {
            return new File(target, "launcher.exe");
        }
        if ("linux".equals(os) || "solaris".equals(os) || "hpux".equals(os) || "aix".equals(os) || "freebsd".equals(os)) {
            return new File(target, "launcher");
        }
        if ("macosx".equals(os)) {
            return new File(target, "Eclipse.app/Contents/MacOS/launcher");
        }
        throw new MojoExecutionException("Unexpected OS: " + os);
    }

    private void setPropertyIfNotNull(Properties properties, String key, String value) {
        if (value != null) {
            properties.setProperty(key, value);
        }
    }
}

