/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.packaging;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.util.IOUtil;
import org.eclipse.tycho.core.ArtifactDependencyVisitor;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.core.shared.BuildProperties;
import org.eclipse.tycho.core.shared.BuildPropertiesParser;
import org.eclipse.tycho.model.Feature;
import org.eclipse.tycho.packaging.AbstractTychoPackagingMojo;
import org.eclipse.tycho.packaging.FeatureXmlTransformer;
import org.eclipse.tycho.packaging.LicenseFeatureHelper;
import org.eclipse.tycho.packaging.UpdateSiteAssembler;

@Mojo(name="package-feature", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class PackageFeatureMojo
extends AbstractTychoPackagingMojo {
    private static final String FEATURE_PROPERTIES = "feature.properties";
    @Parameter
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    @Parameter(property="project.build.directory")
    private File outputDirectory;
    @Parameter(property="project.basedir")
    private File basedir;
    @Parameter(property="project.build.finalName", alias="jarName", required=true)
    private String finalName;
    @Parameter(defaultValue="false")
    private boolean deployableFeature = false;
    @Parameter(defaultValue="${project.build.directory}/site")
    private File target;
    @Component
    private FeatureXmlTransformer featureXmlTransformer;
    @Component
    private LicenseFeatureHelper licenseFeatureHelper;
    @Component
    private BuildPropertiesParser buildPropertiesParser;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.expandVersion();
        this.outputDirectory.mkdirs();
        Feature feature = Feature.loadFeature((File)this.basedir);
        File licenseFeature = this.licenseFeatureHelper.getLicenseFeature(feature, this.project);
        feature.setLicenseFeature(null);
        feature.setLicenseFeatureVersion(null);
        File featureXml = new File(this.outputDirectory, "feature.xml");
        try {
            feature = this.expandVersionQualifiers(feature);
            Feature.write((Feature)feature, (File)featureXml);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error updating feature.xml", (Exception)e);
        }
        BuildProperties buildProperties = this.buildPropertiesParser.parse(this.project.getBasedir());
        this.checkBinIncludesExist(buildProperties, new String[0]);
        File featureProperties = this.getFeatureProperties(licenseFeature, buildProperties);
        File outputJar = new File(this.outputDirectory, this.finalName + ".jar");
        outputJar.getParentFile().mkdirs();
        MavenArchiver archiver = new MavenArchiver();
        JarArchiver jarArchiver = this.getJarArchiver();
        archiver.setArchiver(jarArchiver);
        archiver.setOutputFile(outputJar);
        jarArchiver.setDestFile(outputJar);
        try {
            archiver.getArchiver().addFileSet(this.getManuallyIncludedFiles(buildProperties));
            if (licenseFeature != null) {
                archiver.getArchiver().addArchivedFileSet(this.licenseFeatureHelper.getLicenseFeatureFileSet(licenseFeature));
            }
            archiver.getArchiver().addFile(featureXml, "feature.xml");
            if (featureProperties != null) {
                archiver.getArchiver().addFile(featureProperties, FEATURE_PROPERTIES);
            }
            archiver.createArchive(this.session, this.project, this.archive);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error creating feature package", e);
        }
        this.project.getArtifact().setFile(outputJar);
        if (this.deployableFeature) {
            this.assembleDeployableFeature(feature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File getFeatureProperties(File licenseFeature, BuildProperties buildProperties) throws MojoExecutionException {
        File featureProperties = null;
        if (!buildProperties.getBinIncludes().contains(FEATURE_PROPERTIES)) return featureProperties;
        featureProperties = new File(this.outputDirectory, FEATURE_PROPERTIES);
        if (featureProperties.exists() && !featureProperties.delete()) {
            throw new MojoExecutionException("Could not delete file " + featureProperties.getAbsolutePath());
        }
        BufferedOutputStream os = null;
        try {
            block20: {
                File localFeatureProperties = new File(this.basedir, FEATURE_PROPERTIES);
                if (localFeatureProperties.canRead()) {
                    os = new BufferedOutputStream(new FileOutputStream(featureProperties));
                    BufferedInputStream is = new BufferedInputStream(new FileInputStream(localFeatureProperties));
                    try {
                        IOUtil.copy((InputStream)is, (OutputStream)os);
                    }
                    finally {
                        IOUtil.close((InputStream)is);
                    }
                }
                if (licenseFeature != null) {
                    ZipFile zip = new ZipFile(licenseFeature);
                    try {
                        ZipEntry entry = zip.getEntry(FEATURE_PROPERTIES);
                        if (entry == null) break block20;
                        if (os == null) {
                            os = new BufferedOutputStream(new FileOutputStream(featureProperties));
                        } else {
                            IOUtil.copy((String)"\n", (OutputStream)os);
                        }
                        InputStream is = zip.getInputStream(entry);
                        try {
                            IOUtil.copy((InputStream)is, (OutputStream)os);
                            break block20;
                        }
                        finally {
                            is.close();
                        }
                    }
                    finally {
                        zip.close();
                    }
                }
                if (localFeatureProperties.canRead()) {
                    featureProperties = localFeatureProperties;
                }
            }
            if (os == null) return featureProperties;
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Could not create feature.properties file for project " + this.project, (Exception)e);
            }
            catch (Throwable throwable) {
                if (os == null) throw throwable;
                IOUtil.close(os);
                throw throwable;
            }
        }
        IOUtil.close((OutputStream)os);
        return featureProperties;
    }

    private FileSet getManuallyIncludedFiles(BuildProperties buildProperties) {
        ArrayList<String> binExcludes = new ArrayList<String>(buildProperties.getBinExcludes());
        binExcludes.add("feature.xml");
        binExcludes.add(FEATURE_PROPERTIES);
        return this.getFileSet(this.basedir, buildProperties.getBinIncludes(), binExcludes);
    }

    private void assembleDeployableFeature(Feature feature) throws MojoExecutionException {
        UpdateSiteAssembler assembler = new UpdateSiteAssembler(this.session, this.target);
        this.getDependencyWalker().walk((ArtifactDependencyVisitor)assembler);
    }

    private Feature expandVersionQualifiers(Feature feature) throws MojoExecutionException, IOException {
        return this.featureXmlTransformer.transform(DefaultReactorProject.adapt((MavenProject)this.project), feature, this.getDependencyWalker());
    }

    private JarArchiver getJarArchiver() throws MojoExecutionException {
        try {
            return (JarArchiver)this.plexus.lookup(JarArchiver.ROLE, "jar");
        }
        catch (ComponentLookupException e) {
            throw new MojoExecutionException("Unable to get JarArchiver", (Exception)((Object)e));
        }
    }
}

