/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.buildversion;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.eclipse.tycho.buildversion.AbstractVersionMojo;
import org.eclipse.tycho.core.facade.BuildPropertiesParser;
import org.osgi.framework.Version;

public class BuildQualifierMojo
extends AbstractVersionMojo {
    public static final String BUILD_QUALIFIER_PROPERTY = "buildQualifier";
    public static final String UNQUALIFIED_VERSION_PROPERTY = "unqualifiedVersion";
    private static final String REACTOR_BUILD_TIMESTAMP_PROPERTY = "reactorBuildTimestampProperty";
    private MavenSession session;
    private SimpleDateFormat format;
    private File baseDir;
    private String forceContextQualifier;
    private BuildPropertiesParser buildPropertiesParser;

    public void setFormat(String formatString) {
        this.format = new SimpleDateFormat(formatString);
        this.format.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        String qualifier;
        String osgiVersionStr = this.getOSGiVersion();
        if (osgiVersionStr != null) {
            try {
                Version osgiVersion = Version.parseVersion((String)osgiVersionStr);
                if (!"qualifier".equals(osgiVersion.getQualifier())) {
                    this.project.getProperties().put(BUILD_QUALIFIER_PROPERTY, osgiVersion.getQualifier());
                    this.project.getProperties().put(UNQUALIFIED_VERSION_PROPERTY, osgiVersion.getMajor() + "." + osgiVersion.getMinor() + "." + osgiVersion.getMicro());
                    return;
                }
            }
            catch (IllegalArgumentException e) {
                throw new MojoFailureException("Not a valid OSGi version " + osgiVersionStr + " for project " + this.project);
            }
        }
        if ((qualifier = this.forceContextQualifier) == null) {
            qualifier = this.buildPropertiesParser.parse(this.baseDir).getForceContextQualifier();
        }
        if (qualifier == null) {
            Date timestamp = this.getSessionTimestamp();
            qualifier = this.getQualifier(timestamp);
        }
        this.project.getProperties().put(BUILD_QUALIFIER_PROPERTY, qualifier);
        this.project.getProperties().put(UNQUALIFIED_VERSION_PROPERTY, this.getUnqualifiedVersion());
    }

    String getQualifier(Date timestamp) {
        return this.format.format(timestamp);
    }

    private String getUnqualifiedVersion() {
        String version = this.project.getArtifact().getVersion();
        if (version.endsWith("-SNAPSHOT")) {
            version = version.substring(0, version.length() - "SNAPSHOT".length() - 1);
        }
        return version;
    }

    private Date getSessionTimestamp() {
        Date timestamp;
        String value = this.session.getUserProperties().getProperty(REACTOR_BUILD_TIMESTAMP_PROPERTY);
        if (value != null) {
            timestamp = new Date(Long.parseLong(value));
        } else {
            timestamp = new Date();
            this.session.getUserProperties().setProperty(REACTOR_BUILD_TIMESTAMP_PROPERTY, Long.toString(timestamp.getTime()));
        }
        return timestamp;
    }
}

