/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.eclipse.sisu.equinox.EquinoxServiceFactory;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.p2.facade.internal.ArtifactFacade;
import org.eclipse.tycho.p2.metadata.IArtifactFacade;
import org.eclipse.tycho.p2.metadata.P2Generator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P2MetadataMojo
extends AbstractMojo {
    protected MavenProject project;
    protected boolean attachP2Metadata;
    protected MavenProjectHelper projectHelper;
    private EquinoxServiceFactory equinox;
    private P2Generator p2;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.attachP2Metadata();
    }

    protected P2Generator getP2Generator() {
        if (this.p2 == null) {
            this.p2 = (P2Generator)this.equinox.getService(P2Generator.class);
            if (this.p2 == null) {
                throw new IllegalStateException("Could not acquire P2 metadata service");
            }
        }
        return this.p2;
    }

    protected void attachP2Metadata() throws MojoExecutionException {
        if (!this.attachP2Metadata) {
            return;
        }
        File file = this.project.getArtifact().getFile();
        if (file == null || !file.canRead()) {
            throw new IllegalStateException();
        }
        File targetDir = new File(this.project.getBuild().getDirectory());
        HashMap<String, ArtifactFacade> artifactsToBeAttached = new HashMap<String, ArtifactFacade>();
        ArtifactFacade projectDefaultArtifact = new ArtifactFacade(this.project.getArtifact());
        DefaultArtifact p2contentArtifact = P2MetadataMojo.createP2Artifact(projectDefaultArtifact, "xml", "p2metadata", "p2content.xml", targetDir);
        artifactsToBeAttached.put("p2metadata", new ArtifactFacade((Artifact)p2contentArtifact));
        DefaultArtifact p2artifactsArtifact = P2MetadataMojo.createP2Artifact(projectDefaultArtifact, "xml", "p2artifacts", "p2artifacts.xml", targetDir);
        artifactsToBeAttached.put("p2artifacts", new ArtifactFacade((Artifact)p2artifactsArtifact));
        try {
            ArrayList<ArtifactFacade> artifacts = new ArrayList<ArtifactFacade>();
            artifacts.add(projectDefaultArtifact);
            for (Artifact attachedArtifact : this.project.getAttachedArtifacts()) {
                if (attachedArtifact.getFile() == null || !attachedArtifact.getFile().getName().endsWith(".jar")) continue;
                artifacts.add(new ArtifactFacade(attachedArtifact));
            }
            Map generateMetadata = this.getP2Generator().generateMetadata(artifacts, artifactsToBeAttached, targetDir);
            ReactorProject reactorProject = DefaultReactorProject.adapt((MavenProject)this.project);
            for (Map.Entry entry : generateMetadata.entrySet()) {
                reactorProject.setDependencyMetadata((String)entry.getKey(), true, (Set)entry.getValue());
                reactorProject.setDependencyMetadata((String)entry.getKey(), false, Collections.emptySet());
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not generate P2 metadata", (Exception)e);
        }
        for (Map.Entry entry : artifactsToBeAttached.entrySet()) {
            IArtifactFacade artifactFacade = (IArtifactFacade)entry.getValue();
            this.projectHelper.attachArtifact(this.project, artifactFacade.getPackagingType(), artifactFacade.getClassidier(), artifactFacade.getLocation());
        }
        File localArtifactsFile = new File(this.project.getBuild().getDirectory(), "local-artifacts.properties");
        P2MetadataMojo.writeArtifactLocations(localArtifactsFile, P2MetadataMojo.getAllProjectArtifacts(this.project));
    }

    private static DefaultArtifact createP2Artifact(ArtifactFacade projectDefaultArtifact, String extension, String classifier, String p2ArtifactFileName, File targetDir) {
        DefaultArtifact p2Artifact = new DefaultArtifact(projectDefaultArtifact.getGroupId(), projectDefaultArtifact.getArtifactId(), projectDefaultArtifact.getVersion(), null, extension, classifier, null);
        p2Artifact.setFile(new File(targetDir, p2ArtifactFileName));
        return p2Artifact;
    }

    private static Map<String, File> getAllProjectArtifacts(MavenProject project) {
        HashMap<String, File> artifacts = new HashMap<String, File>();
        Artifact mainArtifact = project.getArtifact();
        if (mainArtifact != null) {
            artifacts.put(null, mainArtifact.getFile());
        }
        for (Artifact attachedArtifact : project.getAttachedArtifacts()) {
            artifacts.put(attachedArtifact.getClassifier(), attachedArtifact.getFile());
        }
        return artifacts;
    }

    static void writeArtifactLocations(File outputFile, Map<String, File> artifactLocations) throws MojoExecutionException {
        Properties outputProperties = new Properties();
        for (Map.Entry<String, File> entry : artifactLocations.entrySet()) {
            if (entry.getKey() == null) {
                outputProperties.put("artifact.main", entry.getValue().getAbsolutePath());
                continue;
            }
            outputProperties.put("artifact.attached." + entry.getKey(), entry.getValue().getAbsolutePath());
        }
        P2MetadataMojo.writeProperties(outputProperties, outputFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeProperties(Properties properties, File outputFile) throws MojoExecutionException {
        try {
            FileOutputStream outputStream = new FileOutputStream(outputFile);
            try {
                properties.store(outputStream, null);
            }
            finally {
                outputStream.close();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("I/O exception while writing " + outputFile, (Exception)e);
        }
    }
}

