/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.ds;

import aQute.bnd.component.DSAnnotations;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Resource;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.tycho.artifacts.configuration.DeclarativeServiceConfigurationReader;
import org.eclipse.tycho.classpath.ClasspathEntry;
import org.eclipse.tycho.core.DeclarativeServicesConfiguration;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.core.osgitools.OsgiBundleProject;

@Mojo(name="declarative-services", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class DeclarativeServicesMojo
extends AbstractMojo {
    @Parameter(property="tycho.ds.classpath", defaultValue="true")
    private boolean classpath = Boolean.parseBoolean("true");
    @Parameter(property="tycho.ds.version", defaultValue="1.3")
    private String dsVersion = "1.3";
    @Parameter(property="tycho.ds.enabled", defaultValue="false")
    private boolean enabled = false;
    @Parameter(property="tycho.ds.skip", defaultValue="false")
    private boolean skip = false;
    @Parameter(property="tycho.ds.path", defaultValue="OSGI-INF")
    private String path = "OSGI-INF";
    @Parameter(property="project", readonly=true)
    protected MavenProject project;
    @Component(role=TychoProject.class)
    private Map<String, TychoProject> projectTypes;
    @Component
    private DeclarativeServiceConfigurationReader configurationReader;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            return;
        }
        TychoProject projectType = this.projectTypes.get(this.project.getPackaging());
        if (projectType instanceof OsgiBundleProject) {
            try {
                DeclarativeServicesConfiguration configuration = this.configurationReader.getConfiguration(this.project);
                if (configuration == null) {
                    return;
                }
                File outputDirectory = new File(this.project.getBuild().getOutputDirectory());
                String childPath = configuration.getPath();
                File targetDirectory = new File(outputDirectory, childPath);
                File projectBaseDir = new File(this.project.getBasedir(), childPath);
                try (Jar mavenProjectJar = new Jar(this.project.getName(), outputDirectory, null);
                     Analyzer analyzer = new Analyzer(mavenProjectJar);){
                    Map directory = analyzer.getJar().getDirectory("OSGI-INF");
                    if (directory != null) {
                        directory.clear();
                    }
                    OsgiBundleProject bundleProject = (OsgiBundleProject)projectType;
                    List classpath = bundleProject.getClasspath(DefaultReactorProject.adapt((MavenProject)this.project));
                    for (ClasspathEntry entry : classpath) {
                        List locations = entry.getLocations();
                        for (File file : locations) {
                            if (!file.exists()) continue;
                            analyzer.addClasspath(file);
                        }
                    }
                    analyzer.addBasicPlugin((Object)new DSAnnotations());
                    analyzer.analyze();
                    String components = analyzer.getProperty("Service-Component");
                    if (components == null || components.isBlank()) {
                        return;
                    }
                    for (String component : components.split(",\\s*")) {
                        Resource resource;
                        String name = FilenameUtils.getName((String)component);
                        if (new File(projectBaseDir, name).isFile() || (resource = analyzer.getJar().getResource(component)) == null) continue;
                        File file = new File(targetDirectory, name);
                        file.getParentFile().mkdirs();
                        resource.write(file);
                    }
                }
            }
            catch (Exception e) {
                throw new MojoFailureException("generation of ds components failed: " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

