/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.bndlib;

import aQute.bnd.header.Attrs;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Clazz;
import aQute.bnd.osgi.Descriptors;
import aQute.bnd.osgi.FileResource;
import aQute.bnd.osgi.Resource;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.tycho.bndlib.JDTClazz;
import org.eclipse.tycho.bndlib.source.SourceCodeResolver;
import org.eclipse.tycho.bndlib.source.SourceFile;

public class SourceCodeAnalyzer
implements FileVisitor<Path> {
    private static final String PACKAGE_INFO = "package-info";
    private static final String ANNOTATION_VERSION = "org.osgi.annotation.versioning.Version";
    private static final String ANNOTATION_EXPORT = "org.osgi.annotation.bundle.Export";
    private static final String PACKAGE_INFO_JAVA = "package-info.java";
    private static final String PACKAGE_INFO_CLASS = "package-info.class";
    private Set<String> seenPackages = new HashSet<String>();
    private Set<Path> analyzedPath = new HashSet<Path>();
    Map<Descriptors.PackageRef, Clazz> packageInfoMap = new HashMap<Descriptors.PackageRef, Clazz>();
    private Analyzer analyzer;
    private SourceCodeResolver typeResolver;

    public SourceCodeAnalyzer(Analyzer analyzer, SourceCodeResolver typeResolver) {
        this.analyzer = analyzer;
        this.typeResolver = typeResolver;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        boolean packageInfo;
        String fileName = file.getFileName().toString().toLowerCase();
        if (fileName.endsWith(".java") && ((packageInfo = fileName.equals(PACKAGE_INFO_JAVA)) || this.analyzedPath.add(file.getParent()))) {
            this.analyzeSourceFile(file, packageInfo);
        }
        return FileVisitResult.CONTINUE;
    }

    private void analyzeSourceFile(Path file, boolean packageInfo) throws IOException {
        SourceFile source = this.typeResolver.getCompilationUnit(file);
        PackageDeclaration packageDecl = source.getPackage();
        if (packageDecl != null) {
            String packageFqdn = packageDecl.getName().getFullyQualifiedName();
            Descriptors.PackageRef packageRef = this.analyzer.getPackageRef(packageFqdn);
            if (this.seenPackages.add(packageFqdn)) {
                this.analyzer.getContained().put(packageRef);
            }
            if (packageInfo) {
                JDTClazz clazz = new JDTClazz(this.analyzer, packageRef.getBinary() + "/package-info.class", (Resource)new FileResource(file), this.analyzer.getTypeRef(packageRef.getBinary() + "/package-info"));
                for (Object raw : packageDecl.annotations()) {
                    String version;
                    if (!(raw instanceof Annotation)) continue;
                    Annotation annot = (Annotation)raw;
                    Name typeName = annot.getTypeName();
                    String annotationFqdn = typeName.getFullyQualifiedName();
                    if (source.isType(annotationFqdn, ANNOTATION_EXPORT)) {
                        clazz.addAnnotation(this.analyzer.getTypeRef(ANNOTATION_EXPORT.replace('.', '/')));
                        this.packageInfoMap.put(packageRef, clazz);
                        continue;
                    }
                    if (!source.isType(annotationFqdn, ANNOTATION_VERSION) || (version = this.getVersionFromAnnotation(annot, source)) == null) continue;
                    this.analyzer.getContained().put(packageRef, Attrs.create((String)"version", (String)version));
                }
            }
        }
    }

    private String getVersionFromAnnotation(Annotation annot, SourceFile source) {
        if (annot instanceof NormalAnnotation) {
            NormalAnnotation normal = (NormalAnnotation)annot;
            for (Object vp : normal.values()) {
                MemberValuePair pair = (MemberValuePair)vp;
                if (!"value".equals(pair.getName().getFullyQualifiedName())) continue;
                return source.resolve(pair.getValue());
            }
        } else if (annot instanceof SingleMemberAnnotation) {
            SingleMemberAnnotation single = (SingleMemberAnnotation)annot;
            return source.resolve(single.getValue());
        }
        return null;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        return FileVisitResult.CONTINUE;
    }
}

