/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho;

import java.util.Objects;
import org.eclipse.tycho.ArtifactKey;

public class DefaultArtifactKey
implements ArtifactKey {
    private final String type;
    private final String id;
    private final String version;

    public DefaultArtifactKey(String type, String id) {
        this(type, id, "0.0.0");
    }

    public DefaultArtifactKey(String type, String id, String version) {
        this.id = id;
        this.type = type;
        this.version = version;
    }

    public int hashCode() {
        return Objects.hash(this.getType(), this.getId(), this.getVersion());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof ArtifactKey)) return false;
        ArtifactKey other = (ArtifactKey)obj;
        if (!Objects.equals(this.getType(), other.getType())) return false;
        if (!Objects.equals(this.getId(), other.getId())) return false;
        if (!Objects.equals(this.getVersion(), other.getVersion())) return false;
        return true;
    }

    public String toString() {
        return this.getType() + ":" + this.getId() + ":" + this.getVersion();
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getVersion() {
        return this.version;
    }
}

