/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.osgi.connect;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;

final class DummyClassRealm
extends ClassRealm {
    private static final String JAR_PREFIX = "jar:";
    private static final String JAR_FILE_PREFIX = "jar:file:";
    private ClassLoader classLoader;
    private List<URL> urls;

    DummyClassRealm(String id, ClassLoader classLoader) {
        super(new ClassWorld(), id, classLoader);
        this.classLoader = classLoader;
    }

    public URL[] getURLs() {
        if (this.urls == null) {
            this.urls = new ArrayList<URL>();
            try {
                Enumeration<URL> resources = this.classLoader.getResources("META-INF/MANIFEST.MF");
                while (resources.hasMoreElements()) {
                    String location = resources.nextElement().toExternalForm();
                    if (!location.startsWith(JAR_FILE_PREFIX)) continue;
                    String name = location.substring(JAR_PREFIX.length()).split("!")[0];
                    this.urls.add(new URL(name));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return (URL[])this.urls.toArray(URL[]::new);
    }

    public Class<?> loadClassFromSelf(String name) {
        try {
            return this.classLoader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public URL loadResourceFromSelf(String name) {
        return this.classLoader.getResource(name);
    }

    public Enumeration<URL> loadResourcesFromSelf(String name) {
        try {
            return this.classLoader.getResources(name);
        }
        catch (IOException e) {
            return null;
        }
    }
}

