/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.equinox.launching;

import java.io.File;
import org.eclipse.sisu.equinox.launching.EquinoxInstallation;
import org.eclipse.sisu.equinox.launching.EquinoxInstallationDescription;
import org.eclipse.sisu.equinox.launching.ProvisionedInstallationDescription;
import org.eclipse.sisu.equinox.launching.internal.EquinoxInstallationLaunchConfiguration;

public class ProvisionedEquinoxInstallation
implements EquinoxInstallation {
    private File location;
    private File launcherJar;
    private File configurationLocation;
    private EquinoxInstallationDescription description;

    public ProvisionedEquinoxInstallation(File location) {
        this.location = location;
        this.description = new ProvisionedInstallationDescription(location);
    }

    public File getLauncherJar() {
        if (this.launcherJar != null) {
            return this.launcherJar;
        }
        this.launcherJar = EquinoxInstallationLaunchConfiguration.findLauncherJar(this.location);
        return this.launcherJar;
    }

    public File getLocation() {
        return this.location;
    }

    public File getConfigurationLocation() {
        if (this.configurationLocation != null) {
            return this.configurationLocation;
        }
        this.configurationLocation = EquinoxInstallationLaunchConfiguration.findConfigurationArea(this.location);
        return this.configurationLocation;
    }

    public EquinoxInstallationDescription getInstallationDescription() {
        return this.description;
    }
}

