/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2maven.transport;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepositoryFactory;
import org.eclipse.equinox.internal.p2.repository.DownloadStatus;
import org.eclipse.equinox.internal.p2.repository.helpers.ChecksumHelper;
import org.eclipse.equinox.internal.p2.repository.helpers.RepositoryHelper;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.tycho.helper.MavenPropertyHelper;
import org.eclipse.tycho.p2maven.transport.TransportCacheConfig;
import org.eclipse.tycho.transport.ArtifactDownloadProvider;

@Named
public class BundlePoolArtifactDownloadProvider
implements ArtifactDownloadProvider {
    private SimpleArtifactRepositoryFactory artifactRepositoryFactory;
    private Map<Path, IArtifactRepository> repositoryMap = new ConcurrentHashMap<Path, IArtifactRepository>();
    private TransportCacheConfig cacheConfig;
    private Logger logger;
    private boolean useSharedPools;
    private boolean useWorkspacePools;
    private int priority;

    @Inject
    public BundlePoolArtifactDownloadProvider(SimpleArtifactRepositoryFactory artifactRepositoryFactory, TransportCacheConfig cacheConfig, Logger logger, MavenPropertyHelper propertyHelper) {
        this.artifactRepositoryFactory = artifactRepositoryFactory;
        this.cacheConfig = cacheConfig;
        this.logger = logger;
        this.useSharedPools = propertyHelper.getGlobalBooleanProperty("tycho.p2.transport.bundlepools.shared", true);
        this.useWorkspacePools = propertyHelper.getGlobalBooleanProperty("tycho.p2.transport.bundlepools.workspace", true);
        this.priority = propertyHelper.getGlobalIntProperty("tycho.p2.transport.bundlepools.priority", 100);
    }

    public IStatus downloadArtifact(URI source, OutputStream target, IArtifactDescriptor originalDescriptor) {
        return ((Stream)this.pools().parallel()).flatMap(path -> {
            IArtifactKey artifactKey;
            IFileArtifactRepository filerepository;
            File artifactFile;
            IArtifactRepository repository = this.getRepository((Path)path);
            if (repository instanceof IFileArtifactRepository && (artifactFile = (filerepository = (IFileArtifactRepository)repository).getArtifactFile(artifactKey = originalDescriptor.getArtifactKey())) != null) {
                return Arrays.stream(repository.getArtifactDescriptors(artifactKey)).map(descriptor -> new RepositoryCandidate(filerepository, (IArtifactDescriptor)descriptor, artifactFile.toPath()));
            }
            return Stream.empty();
        }).filter(cand -> this.isMatch((RepositoryCandidate)cand, originalDescriptor)).findAny().map(candidate -> {
            IFileArtifactRepository repository = candidate.repository();
            if (this.cacheConfig.isInteractive()) {
                this.logger.info("Reading from " + repository.getName() + ": " + String.valueOf(candidate.artifactFile()));
            }
            return BundlePoolArtifactDownloadProvider.copyToTarget(target, candidate.artifactFile());
        }).orElse(Status.CANCEL_STATUS);
    }

    private boolean isMatch(RepositoryCandidate candidate, IArtifactDescriptor originalDescriptor) {
        Path artifactFile = candidate.artifactFile();
        if (Files.isRegularFile(artifactFile, new LinkOption[0])) {
            String key;
            IArtifactDescriptor repositoryDescriptor = candidate.descriptor();
            for (Map.Entry entry : originalDescriptor.getProperties().entrySet()) {
                String property;
                key = (String)entry.getKey();
                if (!key.startsWith("download.checksum.") || (property = repositoryDescriptor.getProperty(key)) == null) continue;
                String value = (String)entry.getValue();
                return value.equals(property);
            }
            if (this.fileSizeMatch(repositoryDescriptor, originalDescriptor)) {
                for (Map.Entry entry : originalDescriptor.getProperties().entrySet()) {
                    key = (String)entry.getKey();
                    if (!key.startsWith("download.checksum.")) continue;
                    try {
                        String algorithm = key.substring("download.checksum.".length()).toUpperCase();
                        MessageDigest md = MessageDigest.getInstance(algorithm);
                        try (DigestOutputStream outputStream = new DigestOutputStream(OutputStream.nullOutputStream(), md);
                             InputStream inputStream = Files.newInputStream(artifactFile, new OpenOption[0]);){
                            inputStream.transferTo(outputStream);
                        }
                        return ChecksumHelper.toHexString((byte[])md.digest()).equals(entry.getValue());
                    }
                    catch (Exception exception) {
                    }
                }
            }
        }
        return false;
    }

    private static IStatus copyToTarget(OutputStream target, Path path) {
        try {
            Files.copy(path, target);
        }
        catch (IOException e) {
            return Status.error((String)"Can't copy file to target", (Throwable)e);
        }
        DownloadStatus status = new DownloadStatus(0, "org.eclipse.tycho", "File " + String.valueOf(path), null);
        try {
            status.setFileSize(Files.size(path));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            status.setLastModified(Files.getLastModifiedTime(path, new LinkOption[0]).toMillis());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return status;
    }

    private boolean fileSizeMatch(IArtifactDescriptor repositoryDescriptor, IArtifactDescriptor originalDescriptor) {
        String property;
        String originalSize = originalDescriptor.getProperty("download.size");
        if (originalSize != null && (property = repositoryDescriptor.getProperty("download.size")) != null) {
            return originalSize.equals(property);
        }
        return true;
    }

    private Stream<Path> pools() {
        if (this.useSharedPools) {
            if (this.useWorkspacePools) {
                List sharedBundlePools = RepositoryHelper.getSharedBundlePools();
                List workspaceBundlePools = RepositoryHelper.getWorkspaceBundlePools();
                return Stream.concat(sharedBundlePools.stream(), workspaceBundlePools.stream()).distinct();
            }
            return RepositoryHelper.getSharedBundlePools().stream();
        }
        if (this.useWorkspacePools) {
            return RepositoryHelper.getWorkspaceBundlePools().stream();
        }
        return Stream.empty();
    }

    private IArtifactRepository getRepository(Path path) {
        return this.repositoryMap.computeIfAbsent(path, p -> {
            try {
                return this.artifactRepositoryFactory.load(path.toUri(), 0, null);
            }
            catch (ProvisionException e) {
                return null;
            }
        });
    }

    public int getPriority() {
        return this.priority;
    }

    private record RepositoryCandidate(IFileArtifactRepository repository, IArtifactDescriptor descriptor, Path artifactFile) {
    }
}

