/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2maven;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactDescriptor;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.PublisherResult;
import org.eclipse.equinox.p2.publisher.actions.IPropertyAdvice;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;

@Component(role=InstallableUnitPublisher.class)
public class InstallableUnitPublisher {
    public Collection<IInstallableUnit> publishMetadata(Collection<? extends IPublisherAction> actions) throws CoreException {
        return this.publishMetadata(actions, Collections.emptyList());
    }

    public Collection<IInstallableUnit> publishMetadata(Collection<? extends IPublisherAction> actions, Collection<? extends IPublisherAdvice> advices) throws CoreException {
        if (actions.isEmpty()) {
            return new HashSet<IInstallableUnit>();
        }
        PublisherInfo publisherInfo = new PublisherInfo();
        publisherInfo.setArtifactOptions(1);
        for (IPublisherAdvice iPublisherAdvice : advices) {
            publisherInfo.addAdvice(iPublisherAdvice);
        }
        PublisherResult results = new PublisherResult();
        for (IPublisherAction iPublisherAction : actions) {
            IStatus status = iPublisherAction.perform((IPublisherInfo)publisherInfo, (IPublisherResult)results, (IProgressMonitor)new NullProgressMonitor());
            if (!status.matches(4)) continue;
            throw new CoreException(status);
        }
        IQueryResult iQueryResult = results.query(QueryUtil.ALL_UNITS, null);
        return iQueryResult.toSet();
    }

    public void applyAdvices(Collection<IInstallableUnit> units, IArtifactDescriptor descriptor, Collection<? extends IPublisherAdvice> advices) {
        PublisherInfo publisherInfo = new PublisherInfo();
        publisherInfo.setArtifactOptions(1);
        for (IPublisherAdvice iPublisherAdvice : advices) {
            publisherInfo.addAdvice(iPublisherAdvice);
        }
        for (IInstallableUnit iInstallableUnit : units) {
            Collection advice = publisherInfo.getAdvice(null, false, iInstallableUnit.getId(), iInstallableUnit.getVersion(), IPropertyAdvice.class);
            for (IPropertyAdvice entry : advice) {
                Map props = entry.getArtifactProperties(iInstallableUnit, descriptor);
                if (props == null || !(descriptor instanceof SimpleArtifactDescriptor)) continue;
                SimpleArtifactDescriptor simpleArtifactDescriptor = (SimpleArtifactDescriptor)descriptor;
                for (Map.Entry pe : props.entrySet()) {
                    simpleArtifactDescriptor.setRepositoryProperty((String)pe.getKey(), (String)pe.getValue());
                }
            }
        }
    }
}

